package com.clx.performance.service.loan;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.loan.carrier.CarrierOwnerLoanRecordApproveParam;
import com.clx.performance.param.pc.loan.carrier.PageCarrierOwnerLoanRecordParam;
import com.clx.performance.param.pc.loan.carrier.PageOwnerLoanRecordOfOwner;
import com.clx.performance.param.pc.loan.owner.ExportPaymentApplicationFormParam;
import com.clx.performance.param.pc.loan.owner.OwnerLoanRecordParam;
import com.clx.performance.vo.pc.loan.carrier.OwnerLoanRecordVO;
import com.clx.performance.vo.pc.loan.carrier.CarrierCashierInfoVO;
import com.clx.performance.vo.pc.loan.carrier.OwnerOrderPaymentDetailVO;
import com.clx.performance.vo.pc.loan.owner.OwnerLoanRecordDetail;
import com.clx.performance.vo.pc.loan.carrier.CarrierTransferPaymentDetailVO;

import java.math.BigDecimal;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 17:05
 */
public interface OwnerLoanRecordService {
    IPage<OwnerLoanRecordVO> pageOwnerLoanRecord(PageCarrierOwnerLoanRecordParam param);

    void ownerLoanRecordSubmit(OwnerLoanRecordParam param);

    void ownerLoanRecordApprove(CarrierOwnerLoanRecordApproveParam param);

    IPage<OwnerLoanRecordVO> pageOwnerLoanRecordOfOwner(PageOwnerLoanRecordOfOwner param);

    OwnerLoanRecordDetail getOwnerLoanRecordDetail();

    CarrierCashierInfoVO getCashierInfo(Integer id);

    OwnerOrderPaymentDetailVO getOrderPaymentDetail(Integer id);

    CarrierTransferPaymentDetailVO getTransferPaymentDetail(Integer id);

    String savePaymentApplicationForm(ExportPaymentApplicationFormParam param);

    void getLoanBalance(BigDecimal orderChildPrice, Long userNo, String childNo);
}
