package com.clx.performance.service.impl.loan;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dao.loan.OwnerLoanAccountDao;
import com.clx.performance.model.loan.OwnerLoanAccount;
import com.clx.performance.param.pc.loan.carrier.PageOwnerLoanAccountParam;
import com.clx.performance.service.loan.OwnerLoanAccountService;
import com.clx.performance.struct.loan.OwnerLoanAccountStruct;
import com.clx.performance.vo.pc.loan.carrier.CarrierOwnerLoanAccountVO;
import com.clx.performance.vo.pc.loan.owner.OwnerAccountVO;
import com.msl.common.base.Optional;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Service
@Slf4j
@AllArgsConstructor
public class OwnerLoanAccountServiceImpl  implements OwnerLoanAccountService {

    private final OwnerLoanAccountDao ownerLoanAccountDao;

    private final OwnerLoanAccountStruct ownerLoanAccountStruct;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void openOwnerLoanAccount(Long ownerUserNo, String ownerUserName, String mobile) {
        OwnerLoanAccount entity = new OwnerLoanAccount();
        entity.setOwnerUserNo(ownerUserNo);
        entity.setMobile(mobile);
        entity.setOwnerUserName(ownerUserName);
        entity.setFundingAccountBalance(BigDecimal.ZERO);
        entity.setFundingFrozenBalance(BigDecimal.ZERO);
        entity.setFundingUsableBalance(BigDecimal.ZERO);
        entity.setFundingArrears(BigDecimal.ZERO);

        entity.setVirtuallyArrears(BigDecimal.ZERO);
        entity.setVirtuallyAccountBalance(BigDecimal.ZERO);
        entity.setVirtuallyUsableBalance(BigDecimal.ZERO);
        entity.setVirtuallyFrozenBalance(BigDecimal.ZERO);
        ownerLoanAccountDao.saveEntity(entity);
    }

    @Override
    @UnitCovert(param = false)
    public IPage<CarrierOwnerLoanAccountVO> pageOwnerLoanAccount(PageOwnerLoanAccountParam param) {
        return ownerLoanAccountDao.pageByParam(param);
    }

    @Override
    public OwnerAccountVO getOwnerLoanAccount() {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Optional<OwnerLoanAccount> optional = ownerLoanAccountDao.getOneByField(OwnerLoanAccount::getOwnerUserNo,
                loginUserInfo.getUserNo());
        if(!optional.isPresent()){
            return OwnerAccountVO.builder().openAccount(0).build();
        }
        OwnerLoanAccount ownerLoanAccount  = optional.get();
        return  ownerLoanAccountStruct.convertVO(ownerLoanAccount);
    }
}
