package com.clx.performance.dao.impl.loan;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.loan.BorrowerDao;
import com.clx.performance.enums.loan.BorrowerEnum;
import com.clx.performance.mapper.loan.BorrowerMapper;
import com.clx.performance.model.loan.Borrower;
import com.clx.performance.param.pc.loan.carrier.PageBorrowerParam;
import com.clx.performance.vo.pc.loan.carrier.BorrowerVO;
import com.clx.performance.vo.pc.loan.owner.BorrowerSelectVO;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author: aiqinguo
 * @Description: 借出方
 * @Date: 2024/01/17 13:42:57
 * @Version: 1.0
 */
@Repository
public class BorrowerDaoImpl extends BaseDaoImpl<BorrowerMapper, Borrower, Integer> implements BorrowerDao {


    @Override
    public boolean update(Borrower item) {
        return update(lUdWrapper()
                .eq(Borrower::getId, item.getId())
                .set(Borrower::getName, item.getName())
                .set(Borrower::getBankName, item.getBankName())
                .set(Borrower::getBankCardNo, item.getBankCardNo())
                .set(Borrower::getOpenBankId, item.getOpenBankId())
                .set(Borrower::getOpenBankName, item.getOpenBankName())

                .set(Borrower::getOpUserNo, item.getOpUserNo())
                .set(Borrower::getOpUserName, item.getOpUserName())
                .set(Borrower::getOpTime, item.getOpTime())
        );
    }

    @Override
    public boolean updateStatus(Borrower item) {
        return update(lUdWrapper()
                .eq(Borrower::getId, item.getId())
                .set(Borrower::getStatus, item.getStatus())

                .set(Borrower::getOpUserNo, item.getOpUserNo())
                .set(Borrower::getOpUserName, item.getOpUserName())
                .set(Borrower::getOpTime, item.getOpTime())
        );
    }

    @Override
    public boolean updateDelete(Borrower item) {
        return update(lUdWrapper()
                .eq(Borrower::getId, item.getId())
                .set(Borrower::getDeleteStatus, item.getDeleteStatus())

                .set(Borrower::getOpUserNo, item.getOpUserNo())
                .set(Borrower::getOpUserName, item.getOpUserName())
                .set(Borrower::getOpTime, item.getOpTime())
        );
    }

    @Override
    public Optional<Borrower> selectByName(String name) {
        return Optional.of(name)
                .map(item -> lQrWrapper()
                        .eq(Borrower::getName, item)
                        .eq(Borrower::getDeleteStatus, BorrowerEnum.DeleteStatus.NO.getCode())
                        .last("limit 1")
                )
                .map(super::getOne);
    }

    @Override
    public List<Borrower> listEnable() {
        return list(lQrWrapper()
                .eq(Borrower::getDeleteStatus, BorrowerEnum.DeleteStatus.NO.getCode())
                .eq(Borrower::getStatus, BorrowerEnum.Status.ENABLE.getCode())
        );
    }

    @Override
    public IPage<BorrowerVO> pageByParam(PageBorrowerParam param) {
        Page<BorrowerVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageByParam(page,param);

    }

    @Override
    public List<BorrowerSelectVO> selectAllBorrowConfig() {
        return baseMapper.selectAllBorrowConfig();
    }
}
