package com.clx.performance.controller.pc.loan.owner;

import com.clx.performance.param.pc.loan.owner.OwnerLoanRecordParam;
import com.clx.performance.service.loan.OwnerLoanAccountApproveService;
import com.clx.performance.service.loan.OwnerLoanAccountService;
import com.clx.performance.service.loan.OwnerLoanRecordService;
import com.clx.performance.vo.pc.loan.owner.OwnerAccountVO;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;


@Slf4j
@RestController
@RequestMapping(value="/pc/owner/loanAccountApprove")
@Validated
@Api(tags = "货主端-资金管理（货主借款账户管理（申请借款））")
@AllArgsConstructor
public class OwnerLoanAccountController {

    private final OwnerLoanAccountApproveService ownerLoanAccountApproveService;

    private final OwnerLoanRecordService ownerLoanRecordService;

    private final OwnerLoanAccountService ownerLoanAccountService;

    @ApiOperation(value = "货主借款账户开通",notes = "<br>By:胡宇帆")
    @GetMapping("/openOwnerLoanAccount")
    public Result<Object> openOwnerLoanAccount() {
        ownerLoanAccountApproveService.openOwnerLoanAccountApprove();
        return Result.ok();
    }


    @ApiOperation(value = "货主借款申请",notes = "<br>By:胡宇帆")
    @PostMapping("/ownerLoanRecordSubmit")
    public Result<Object> ownerLoanRecordSubmit(@RequestBody OwnerLoanRecordParam param) {
        ownerLoanRecordService.ownerLoanRecordSubmit(param);
        return Result.ok();
    }



    @ApiOperation(value = "货主借款账户信息",notes = "<br>By:刘海泉")
    @GetMapping("/getOwnerLoanAccount")
    @UnitCovert(param = false)
    public Result<OwnerAccountVO> getOwnerLoanAccount() {
        OwnerAccountVO ownerAccount = ownerLoanAccountService.getOwnerLoanAccount();
        return Result.ok(ownerAccount);
    }
}
