package com.clx.performance.vo.pc.loan.carrier;

import com.clx.performance.enums.loan.OwnerLoanRecordEnum;
import com.clx.performance.enums.loan.OwnerRePaymentEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 17:05
 */
@Getter
@Setter
public class OwnerLoanRecordVO {

    private Integer id;

   
    @ApiModelProperty("货主编码")
    private String ownerUserNo;

   
    @ApiModelProperty("货主名称")
    private String ownerUserName;

   
    @ApiModelProperty("联系电话")
    private String mobile;

   
    @ApiModelProperty("交易流水号（第三方）")
    private String runningWaterOpenNo;

    @ApiModelProperty("商户流水号")
    private String merchantRunningWaterNo;

    @ApiModelProperty("汇款识别码")
    private String remittanceIdentificationCode;

   
    @ApiModelProperty("借款单号")
    private String loanNo;

   
    @ApiModelProperty("借款类型 1:虚拟货币  2:资金")
    private Integer loanType;

    @ApiModelProperty("借款类型 虚拟货币  资金")
    private String loanTypeMsg;

    public String getLoanTypeMsg(){
        return OwnerLoanRecordEnum.LoanType.getMsgByCode(loanType);
    }

    @MoneyOutConvert
    @ApiModelProperty("借款金额")
    private BigDecimal loanBalance;

   
    @ApiModelProperty("借款方")
    private String borrower;

   
    @ApiModelProperty("借出方")
    private String lendingParty;

   
    @ApiModelProperty("借出方账户")
    private String lendingPartyAccount;

   
    @ApiModelProperty("收款方")
    private String payee;

   
    @ApiModelProperty("收款账户")
    private String payeeAccount;


    @ApiModelProperty("收款银行")
    private String payeeBank;

    @ApiModelProperty("收款行号")
    private String payeeBankCode;

   
    @ApiModelProperty("10 待审批  20 审批通过   30 审批拒绝  40 付款中  50 付款成功 60 付款失败 ")
    private Integer status;


    @ApiModelProperty("10 待审批  20 审批通过   30 审批拒绝  40 付款中  50 付款成功 60 付款失败 ")
    private String statusMsg;

    public String getStatusMsg(){
        return OwnerLoanRecordEnum.Status.getMsgByCode(status);
    }


   
    @ApiModelProperty("审批时间")
    private String approveTime;

   
    @ApiModelProperty("审批人")
    private String approveBy;

   
    @ApiModelProperty("拒绝原因")
    private String rejectReason;

   
    @ApiModelProperty("借款归还时间")
    private String loanRepaymentTime;


    @ApiModelProperty("支付渠道 10 订单支付 20 转账支付")
    private Integer payChannel;

    @ApiModelProperty("支付渠道 10 订单支付 20 转账支付")
    private String payChannelMsg;

    public String getPayChannelMsg(){
        return OwnerRePaymentEnum.Channel.getMsgByCode(payChannel);
    }

   
    @ApiModelProperty("创建人")
    private String createBy;

   
    @ApiModelProperty("创建时间")
    private String createTime;

   
    @ApiModelProperty("修改时间")
    private String modifiedTime;

}
