package com.clx.performance.vo.pc.loan.carrier;

import com.clx.performance.enums.loan.OwnerLoanRecordEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.math.BigDecimal;

/**
 * @ClassName TransferPaymentDetailVO
 * @Description
 * @Author kavin
 * @Date 2024/1/24 16:57
 * @Version 1.0
 */

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class CarrierTransferPaymentDetailVO {

    @ApiModelProperty("收款户名")
    private String payee;

    @ApiModelProperty("收款账号")
    private String payeeAccount;


    @ApiModelProperty("汇款识别码")
    private String remittanceIdentificationCode;


    @ApiModelProperty("收款银行")
    private String payeeBank;


    @ApiModelProperty("收款行号")
    private String payeeBankNo;


    @MoneyOutConvert
    @ApiModelProperty("订单金额")
    private BigDecimal loanBalance;


    @ApiModelProperty("订单支付状态 10 待付款 40 付款中 50 付款成功 60 付款失败")
    private Integer status;

    @ApiModelProperty("订单支付状态 10 待付款 40 付款中 50 付款成功 60 付款失败")
    private String statusMsg;

    public String getStatusMsg(){
        return OwnerLoanRecordEnum.Status.getMsgByCode(status);
    }

    @ApiModelProperty("付款最后时间")
    public String finalPaymentTime;


}
