package com.clx.performance.enums.loan;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum OwnerRePaymentEnum {
    ;

    //“待付款”，“付款中”，“付款成功”，“付款失败”
    @Getter
    @AllArgsConstructor
    public enum Status {
        PAY_WAIT(10, "待付款"),
        PAYING(40, "付款中"),
        PAY_SUCCESS(50, "付款成功"),
        PAY_FAIL(60, "付款失败"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<OwnerRePaymentEnum.Status> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.code , code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(OwnerRePaymentEnum.Status::getMsg).orElse(null);
        }
    }

    //支付渠道 10 订单支付 20 转账支付
    @Getter
    @AllArgsConstructor
    public enum Channel {
        ORDER(10, "订单支付"),
        TRANSFER(20, "转账支付"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<OwnerRePaymentEnum.Channel> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.code , code)).findFirst();
        }

        public static String getMsgByCode(Integer code) {
            return getByCode(code).map(OwnerRePaymentEnum.Channel::getMsg).orElse(null);
        }
    }


    //10 未逾期  20 已逾期
    @Getter
    @AllArgsConstructor
    public enum BeOverdue {
        NO(10, "未逾期"),
        YES(20, "已逾期"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<OwnerRePaymentEnum.BeOverdue> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.code , code)).findFirst();
        }

        public static String getMsgByCode(Integer code) {
            return getByCode(code).map(OwnerRePaymentEnum.BeOverdue::getMsg).orElse(null);
        }
    }

}
