package com.clx.performance.vo.pc.vehiclewarn;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.clx.performance.enums.OrderChildEnum;
import com.clx.performance.enums.vehiclewarn.VehicleWarnConfigEnum;
import com.clx.performance.enums.vehiclewarn.VehicleWarnInfoEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.time.LocalDateTime;
import java.util.Objects;

/**
* @Author: aiqinguo
* @Description: 车辆预警信息表
* @Date: 2024/04/25 17:09:33
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
public class VehicleWarnInfoVO {

    @Schema(description = "id", example = "1")
    private Integer id;
    @Schema(description = "预警id", example = "1")
    private Integer warnId;
    @Schema(description = "预警名称", example = "超时")
    private String warnName;
    @Schema(description = "预警类型: 1到达货源地延误 2前往货源地超时 3到达目的地延误 4前往目的地超时 5停留超时 6敏感区停留 7装车超时 8卸车超时 9运单延误", example = "1")
    private Integer warnType;
    @Schema(description = "预警类型", example = "1")
    private String warnTypeMsg;
    public String getWarnTypeMsg() {
        return VehicleWarnConfigEnum.WarnType.getMsgByCode(warnType);
    }
    @Schema(description = "预警级别", example = "1")
    private Integer warnLevel;
    @Schema(description = "预警级别", example = "一级")
    private String warnLevelMsg;
    public String getWarnLevelMsg() {
        if (warnLevel == 1) {return "一级";}
        if (warnLevel == 2) {return "二级";}
        if (warnLevel == 3) {return "三级";}
        return null;
    }
    @Schema(description = "货单编号", example = "1000")
    private String orderGoodsNo;
    @Schema(description = "运单编号", example = "1000")
    private String childNo;
    @Schema(description = "发货地址id", example = "1")
    private Integer sendAddressId;
    @Schema(description = "发货地址", example = "北京")
    private String sendAddress;
    @Schema(description = "收货地址id", example = "2")
    private Integer receiveAddressId;
    @Schema(description = "收货地址", example = "山西")
    private String receiveAddress;
    @Schema(description = "运单状态", example = "1")
    private Integer childStatus;
    @Schema(description = "运单状态", example = "1")
    private String childStatusMsg;
    public String getChildStatusMsg() {
        return OrderChildEnum.Status.getMsgByCode(childStatus);
    }
    @Schema(description = "车辆ID", example = "1")
    private Integer truckId;
    @Schema(description = "车牌号", example = "京A12345")
    private String truckNo;
    @Schema(description = "司机用户编号", example = "100000")
    private Long driverUserNo;
    @Schema(description = "司机姓名", example = "张三")
    private String driverName;
    @Schema(description = "司机手机号", example = "13000000000")
    private String driverMobile;
    @Schema(description = "接单时间", example = "")
    private String takeTime;
    @Schema(description = "预警时间", example = "")
    private String warnTime;
    @Schema(description = "预警暂停时间", example = "")
    private String suspendTime;

    @Schema(description = "处理状态：1待处理 2已处理 3暂停预警", example = "1")
    private Integer status;
    public Integer getStatus() {
        if (Objects.equals(status, VehicleWarnInfoEnum.Status.RESOLVE.getCode())) {return VehicleWarnInfoEnum.Status.RESOLVE.getCode();}

        if (StringUtils.isNotBlank(suspendTime)){
            if (LocalDateTimeUtil.parse(suspendTime,"yyyy-MM-dd HH:mm:ss").isBefore(LocalDateTime.now())) {
                return VehicleWarnInfoEnum.Status.INIT.getCode();
            } else {
                return VehicleWarnInfoEnum.Status.SUSPEND.getCode();
            }
        }
        return VehicleWarnInfoEnum.Status.INIT.getCode();
    }
    @Schema(description = "处理状态：1待处理 2已处理 3暂停预警", example = "待处理")
    private String statusMsg;
    public String getStatusMsg() {
        return VehicleWarnInfoEnum.Status.getMsgByCode(getStatus());
    }
    @Schema(description = "创建人", example = "")
    private String createBy;
    @Schema(description = "创建时间", example = "")
    private String createTime;
    @Schema(description = "修改时间", example = "")
    private String modifiedTime;

}