package com.clx.performance.vo.pc.collect;

import com.alibaba.fastjson.JSON;
import com.clx.performance.enums.collect.CollectTruckWaitEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
* @Author: aiqinguo
* @Description: 线路排队耗时
* @Date: 2023/10/16 13:06:27
* @Version: 1.0
*/

@Schema(description = "线路排队耗时")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class CollectTruckWaitVO {

    @Schema(description = "id", example = "")
    private Integer id;
    @Schema(description = "用户编号", example = "")
    private Long userNo;
    @Schema(description = "用户姓名", example = "")
    private String name;
    @Schema(description = "手机号码", example = "")
    private String mobile;
    @Schema(description = "车牌号", example = "")
    private String truckNo;
    @Schema(description = "运单编号", example = "")
    private String childNo;
    @Schema(description = "地址id", example = "")
    private Integer addressId;
    @Schema(description = "详细地址", example = "")
    private String address;
    @Schema(description = "上报类型：1 装车类型 2卸车类型", example = "")
    private Integer reportType;

    @Schema(description = "上报类型：1 装车类型 2卸车类型", example = "")
    private String reportTypeMsg;
    public String getReportTypeMsg() {
        return CollectTruckWaitEnum.ReportType.getByCode(reportType).get().getMsg();
    }

    @Schema(description = "上报类型：1 需要排队 ", example = "")
    private Integer waitType;
    @Schema(description = "上报类型：1 需要排队 ", example = "")
    private String waitTypeMsg;
    public String getWaitTypeMsg() {
        return CollectTruckWaitEnum.waitType.getByCode(waitType).get().getMsg();
    }

    @JsonIgnore
    @Schema(description = "预计站内等待时长", example = "", hidden = true)
    private BigDecimal stationInTime;
    @JsonIgnore
    @Schema(description = "预计站内等待时长图片", example = "", hidden = true)
    private String stationInImage;
    @JsonIgnore
    @Schema(description = "预计站外等待时长", example = "", hidden = true)
    private BigDecimal stationOutTime;
    @JsonIgnore
    @Schema(description = "预计站外等待时长图片", example = "", hidden = true)
    private String stationOutImage;

    @Schema(description = "预计等待时长", example = "")
    private BigDecimal stationTime;

    @Schema(description = "预计等待时长图片", example = "")
    private List<String> stationImageList;
    public List<String> getStationImageList() {
        return StringUtils.isEmpty(stationInImage)? new ArrayList<>() : JSON.parseArray(stationInImage, String.class);
    }

    @Schema(description = "上报时间", example = "")
    private String reportTime;
    @Schema(description = "审核状态：0待审核 1已审核", example = "")
    private Integer auditStatus;
    @Schema(description = "审核状态：0待审核 1已审核", example = "")
    private String auditStatusMsg;
    public String getAuditStatusMsg() {
        return CollectTruckWaitEnum.AuditStatus.getByCode(auditStatus).get().getMsg();
    }
    @Schema(description = "创建时间", example = "")
    private String createTime;
    @Schema(description = "修改时间", example = "")
    private String modifiedTime;

}