package com.clx.performance.vo.pc.broker;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.NotNull;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class TransportPayConfirmParam {

    @Schema(description = "用户编号", required = true)
    @NotNull(message = "用户编号不能为空")
    private String userCode;

    @Schema(description = "运单编号", required = true)
    @NotNull(message = "运单编号不能为空")
    String orderCode;

}
