package com.clx.performance.vo.pc;

import com.clx.performance.enums.OrderEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author kavin
 * Date 2024-07-12
 * Time 16:02
 */
@Getter
@Setter
public class PerformanceProgressVO{

    private Integer id;

    
    @Schema(description="排序")
    private Integer seq;

    
    @Schema(description="订单编号")
    private String orderNo;


    @Schema(description="订单状态： 0待报价 1客户确认中 2报价已确认 3平台已承接 4已取消 5暂停 6拒绝承运 7 挂单中 8运输中 9订单已完成 10 已失效")
    private Integer orderStatus;
    
    @Schema(description="发货-地址id")
    private Integer sendAddressId;

    
    @Schema(description="货源地简称")
    private String sendAddressShorter;

    
    @Schema(description="货源地-标准地址id")
    private Integer sendSystemAddressId;

    
    @Schema(description="货源地-标准地址简称")
    private String sendSystemAddressShorter;

    
    @Schema(description="高级物流经理姓名数组")
    private String seniorLogisticsManagerName;

    
    @Schema(description="货物类型编码")
    private String goodsTypeCode;

    
    @Schema(description="货物类型名称")
    private String goodsTypeName;

    
    @Schema(description="货物名称id")
    private Integer goodsNameId;

    
    @Schema(description="货物名称")
    private String goodsName;

    
    @Schema(description="煤源位置")
    private String sendAddress;

    
    @Schema(description="是否C类煤源  0 否  1 是")
    private Integer sendOverStandard;

    @Schema(description="是否C类煤源  0 否  1 是")
    private String sendOverStandardMsg;

    public String getSendOverStandardMsg(){
        return OrderEnum.OverWeight.getNameByCode(sendOverStandard);
    }

    @Schema(description="司机运费")
    @MoneyOutConvert
    private BigDecimal driverFreightPrice;

    
    @Schema(description="任务吨数")
    private BigDecimal taskWeight;



    
    @Schema(description="挂单吨数")
    private BigDecimal pendingWeight;

    @Schema(description="挂单车数")
    private Integer pendingTruck;

    
    @Schema(description="接单车数")
    private Integer orderedTruckNum;

    @Schema(description="接单吨数")
    private BigDecimal orderedWeight;

    
    @Schema(description="到达货源地车数")
    private Integer arriveSendTruckNum;

    
    @Schema(description="装车车数")
    private Integer loadTruckNum;

    
    @Schema(description="卸车车数")
    private Integer unloadTruckNum;

    
    @Schema(description="在途车数")
    private Integer onTheWayTruckNum;

    
    @Schema(description="接单率")
    private BigDecimal orderedRate;

    
    @Schema(description="任务完成率")
    private BigDecimal taskCompleteRatio;

    
    @Schema(description="矿发吨数")
    private BigDecimal sumLoadWeight;

    
    @Schema(description="到站吨数")
    private BigDecimal sumUnloadWeight;

    
    @Schema(description="在途吨数")
    private BigDecimal sumOnTheWayWeight;

    
    @Schema(description="今日预计完成吨数")
    private BigDecimal todayExpectComplete;

    
    @Schema(description="异常备注")
    private String abnormalRemark;

    
    @Schema(description="履约异常原因")
    private String performanceAbnormalReason;

    
    @Schema(description="调度备注/跟进措施")
    private String dispatchFollow;

    
    @Schema(description="重车运距(公里)")
    private BigDecimal orderDistance;

    
    @Schema(description="可拉运时间段")
    private String transportTimeSlot;

    
    @Schema(description="挂单时间")
    private String pendingTime;

    
    @Schema(description="交易要求到站时间")
    private String tradeRequireArriveStationTime;

    
    @Schema(description="物流要求到站时间")
    private String transportExpectArriveStationTime;

    
    @Schema(description="测算运费")
    @MoneyOutConvert
    private BigDecimal predictionFreightPrice;

    
    @Schema(description="创建时间")
    private String createTime;

    
    @Schema(description="修改时间")
    private String modifiedTime;

}
