package com.clx.performance.vo.app.breakcontract;

import com.alibaba.fastjson.JSON;
import com.clx.performance.enums.BreakContractRecordEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
public class DriverBreakContractDriverRecordVO {

    @Schema(description="id")
    private Integer id;

    @Schema(description="触发类型：1系统触发 2手动触发  3.异常上报")
    private Integer triggerType;

    public String getTriggerTypeMsg(){
        return BreakContractRecordEnum.TriggerType.getMsgByCode(triggerType);
    }


    @Schema(description="违约方类型：1平台 2货主 3司机")
    private Integer breakContractPartyType;

    @Schema(description="违约运单")
    private String childNo;

    @Schema(description="车牌号")
    private String truckNo;

    @Schema(description="车主用户编号")
    private Long truckOwnUserNo;

    @Schema(description="车主名称")
    private String truckOwnName;

    @Schema(description="司机用户编号")
    private Long driverUserNo;

    @Schema(description="司机名称")
    private String driverName;

    @Schema(description="违约金")
    @MoneyOutConvert
    private BigDecimal figure;

    @Schema(description="接单时间限制（小时）")
    private BigDecimal timeLimit;

    @Schema(description="接单限制时间")
    private String limitTime;

    @Schema(description="结算单编号")
    private String settlementNo;

    @Schema(description="违约原因")
    private String remark;

    @Schema(description="异常上报单号")
    private String exceptionReportNo;

    @Schema(description="异常类别")
    private String exceptionCategory;

    @Schema(description="异常类型")
    private String exceptionType;


    @Schema(description="图片字地址符串")
    private String pictureUrl;

    @Schema(description="视频地址字符串")
    private String videoUrl;


    @Schema(description="图片")
    private List<String> pictureUrlList;

    public List<String> getPictureUrlList(){
        if(Objects.nonNull(pictureUrl)){
            return JSON.parseArray(pictureUrl,String.class);
        }
        return null;
    }

    @Schema(description="视频")
    private List<String> videoUrlList;


    public List<String> getVideoUrlList(){
        if(Objects.nonNull(videoUrl)){
            return JSON.parseArray(videoUrl,String.class);
        }
        return null;
    }



    @Schema(description = "操作人名称", example = "")
    private String createName;

    @Schema(description="创建时间")
    private String createTime;

}
