package com.clx.performance.vo.app;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.List;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OrderChildPoundInfoVO {

    @Schema(description = "装货毛重（单位吨）", example = "1.23")
    private BigDecimal loadRough;
    @Schema(description = "装货皮重（单位吨）", example = "1.23")
    private BigDecimal loadTare;
    @Schema(description = "装货净重（单位吨）", example = "1.23")
    private BigDecimal loadNet;
    @Schema(description = "卸货毛重（单位吨）", example = "1.23")
    private BigDecimal unloadRough;
    @Schema(description = "卸货皮重（单位吨）", example = "1.23")
    private BigDecimal unloadTare;
    @Schema(description = "卸货净重（单位吨）", example = "1.23")
    private BigDecimal unloadNet;
    @Schema(description = "卸货磅单编号", example = "url")
    private String unloadPoundNo;

    @Schema(description = "拉运重量（单位吨）", example = "1.23")
    private BigDecimal weight;
    @Schema(description = "运费（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal freight;

    @Schema(description = "磅单审核状态 0 待审核 1 审核通过 2 审核驳回", example = "0")
    private Integer poundStatus;
    @Schema(description = "磅单审核驳回原因", example = "交货信息错误")
    private String poundRemark;
    @Schema(description = "磅单审核驳回类型：1装车 2卸车 3装车+卸车", example = "1")
    private Integer poundRejectType;

    @Schema(description = "状态", example = "0")
    private Integer status;

    @Schema(description = "装车磅单图片列表")
    private List<String> loadImageList;

    @Schema(description = "卸车磅单图片列表")
    private List<String> unloadImageList;

    @Schema(description = "到达货源地时间")
    private String arriveSendTime;

    @Schema(description = "首次装货时间")
    private String firstLoadTime;

    @Schema(description = "到达目的地时间")
    private String arriveReceiveTime;

    @Schema(description = "首次交货时间")
    private String firstUnloadTime;

    @Schema(description = "装货时间")
    private String loadTime;

    @Schema(description = "交货时间")
    private String unloadTime;
}