package com.clx.performance.param.pc;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.NotNull;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OrderChildReportParam {

    @Schema(description = "发货地址id 必填")
    @NotNull(message = "发货地址id不能为空")
    private Integer sendAddressId;

    @Schema(description = "收货地址id 必填")
    @NotNull(message = "收货地址id不能为空")
    private Integer receiveAddressId;

    @Schema(description = "开始时间 必填")
    @NotNull(message = "开始时间")
    private String beginTime;
    @Schema(description = "订单编号")
    private String orderNo;
}
