package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum CarrierExceptionLogEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Type {



        CREATE(1, "创建违约单"),
        TIMEOUT(2, "超时货主处理"),
        APPEAL(3, "申诉"),
        APPEAL_DEAL(4, "申诉处理"),
        AGREE(5, "同意扣罚"),
        TRANSFER_DRIVER_BREAK_CONTRACT(6, "转司机违约"),
        ;

        private final Integer code;
        private final String name;

        public static Optional<Type> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }
        public static String getMsgByCode(Integer code) {
            if (code == null) {return null;}
            return getByCode(code).map(Type::getName).orElse(null);
        }
    }


}
