package com.clx.performance.service.impl.settle;

import com.alibaba.fastjson.JSON;
import com.clx.performance.common.MqDelay;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeySettlementConstants;
import com.clx.performance.service.settle.SettlementMqService;
import com.clx.performance.vo.mq.*;
import com.clx.performance.vo.mq.settle.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class SettlementMqServiceImpl implements SettlementMqService {

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Override
    public void settlementDetailAdd(Integer settlementDriverDetailId, Integer settlementOwnerDetailId) {
        SettlementDetailAddMqParam mq = new SettlementDetailAddMqParam();
        mq.setSettlementDriverDetailId(settlementDriverDetailId);
        mq.setSettlementOwnerDetailId(settlementOwnerDetailId);

        MqDelay<MqWrapper<SettlementDetailAddMqParam>> delay =
                new MqDelay<>(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                        RabbitKeySettlementConstants.SETTLEMENT_DETAIL_ADD_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.DEFAULT_DELAY_ROUTING_KEY, message);

    }

    @Override
    public void settlementStatistics(String childNo) {
        settlementStatistics(childNo, SettlementStatisticsMqParam.Type.STATISTICS.getCode());
    }

    @Override
    public void settlementStatistics(String childNo, Integer type) {

        SettlementStatisticsMqParam mq = new SettlementStatisticsMqParam();
        mq.setChildNo(childNo);
        mq.setType(type);
        MqDelay<MqWrapper<SettlementStatisticsMqParam>> delay =
                new MqDelay<>(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                        RabbitKeySettlementConstants.SETTLEMENT_DETAIL_INVOICE_TYPE_SYC_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void settlementDriverSettle(String childNo) {
        SettlementDriverSettleMqParam mq = new SettlementDriverSettleMqParam();
        mq.setChildNo(childNo);
        MqDelay delay =
                new MqDelay<>(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                        RabbitKeySettlementConstants.SETTLEMENT_DRIVER_SETTLE_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }


    @Override
    public void invoiceTypeSync(String childNo) {

        SettlementInvoiceTypeSyncMqParam mq = new SettlementInvoiceTypeSyncMqParam();
        mq.setChildNo(childNo);
        MqDelay<MqWrapper<SettlementInvoiceTypeSyncMqParam>> delay =
                new MqDelay<>(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                        RabbitKeySettlementConstants.SETTLEMENT_INVOICE_TYPE_SYNC_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void driverPayAcceptSync(String childNo) {
        SettlementDriverPayAcceptSyncMqParam mq = new SettlementDriverPayAcceptSyncMqParam();
        mq.setChildNo(childNo);
        MqDelay delay =
                new MqDelay<>(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                        RabbitKeySettlementConstants.SETTLEMENT_DRIVER_PAY_ACCEPT_SYNC_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void settle(String childNo, Integer invoiceType, String remark) {

        SettlementSettleMqParam mq = new SettlementSettleMqParam();
        mq.setChildNo(childNo);
        mq.setInvoiceType(invoiceType);
        mq.setRemark(remark);
        MqDelay<MqWrapper<SettlementSettleMqParam>> delay = new MqDelay<>(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.SETTLEMENT_SETTLE_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void invoiceStatusSync(String childNo) {
        SettlementInvoiceStatusSyncMqParam mq = new SettlementInvoiceStatusSyncMqParam();
        mq.setChildNo(childNo);
        MqDelay<MqWrapper<SettlementInvoiceStatusSyncMqParam>> delay = new MqDelay<>(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.SETTLEMENT_INVOICE_STATUS_SYNC_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void payStatusSync(String childNo) {
        SettlementPayStatusSyncMqParam mq = new SettlementPayStatusSyncMqParam();
        mq.setChildNo(childNo);
        MqDelay<MqWrapper<SettlementPayStatusSyncMqParam>> delay = new MqDelay<>(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.SETTLEMENT_PAY_STATUS_SYNC_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void riskAdd(Integer id) {
        SettlementOrderChildRiskAddMqParam mq = new SettlementOrderChildRiskAddMqParam();
        mq.setId(id);
        MqDelay delay = new MqDelay<>(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.SETTLEMENT_RISK_ADD_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void riskProcess(Integer id) {
        SettlementOrderChildRiskProcessMqParam mq = new SettlementOrderChildRiskProcessMqParam();
        mq.setId(id);
        MqDelay delay = new MqDelay<>(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.SETTLEMENT_RISK_PROCESS_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void updateInvoiceCompany(Integer id) {
        SettlementOwnerDetialInvoiceCompanyUpdateMqParam mq = new SettlementOwnerDetialInvoiceCompanyUpdateMqParam();
        mq.setId(id);
        MqDelay delay = new MqDelay<>(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.SETTLEMENT_INVOICE_COMPANY_UPDATE_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void settlementPlatformAutoConfirmUpdate(String settlementNo) {
        SettlementPlatformAutoConfirmMqParam mq = new SettlementPlatformAutoConfirmMqParam();
        mq.setSettlementNo(settlementNo);
        MqDelay delay = new MqDelay<>(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.SETTLEMENT_PLATFORM_AUTO_CONFIRM_UPDATE_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void settlementInvoiceStatusUpdate(String settlementNo) {
        SettlementInvoiceStatusUpdateMqParam mq = new SettlementInvoiceStatusUpdateMqParam();
        mq.setSettlementNo(settlementNo);
        MqDelay delay = new MqDelay<>(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.SETTLEMENT_INVOICE_STATUS_UPDATE_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void settlementDriverConfirm(String childNo) {
        SettlementDriverConfirmMqParam mq = new SettlementDriverConfirmMqParam();
        mq.setChildNo(childNo);
        MqDelay delay = new MqDelay<>(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.SETTLEMENT_DRIVER_CONFIRM_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

}
