package com.clx.performance.model.loan;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 17:05
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("owner_loan_record")
public class OwnerLoanRecord implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("owner_user_no")
    @Schema(description="货主编码")
    private Long ownerUserNo;

    @TableField("owner_user_name")
    @Schema(description="货主名称")
    private String ownerUserName;

    @TableField("mobile")
    @Schema(description="联系电话")
    private String mobile;

    @TableField("goods_name")
    @Schema(description="货物名称")
    private String goodsName;

    @TableField("running_water_open_no")
    @Schema(description="交易流水号（第三方）")
    private String runningWaterOpenNo;

    @TableField("merchant_running_water_no")
    @Schema(description="商户流水号")
    private String merchantRunningWaterNo;

    @TableField("loan_no")
    @Schema(description="借款单号")
    private Long loanNo;

    @TableField("loan_type")
    @Schema(description="借款类型 1:虚拟货币  2:资金")
    private Integer loanType;

    @TableField("loan_balance")
    @Schema(description="借款金额")
    private BigDecimal loanBalance;

    @TableField("loan_residue_balance")
    @Schema(description="借款剩余金额")
    private BigDecimal loanResidueBalance;


    @TableField("borrower_id")
    @Schema(description="借出方Id")
    private Integer borrowerId;

    @TableField("borrower")
    @Schema(description="借出方")
    private String borrower;

    @Schema(description="借出方账户")
    @TableField("borrower_account")
    private String borrowerAccount;


    @TableField("borrower_bank")
    @Schema(description="借出方银行")
    private String borrowerBank;

    @TableField("borrower_bank_code")
    @Schema(description="借出方银行行号")
    private String borrowerBankCode;

    @TableField("borrower_open_bank")
    @Schema(description="借出方开户行")
    private String borrowerOpenBank;

    @TableField("remittance_identification_code")
    @Schema(description="汇款识别码")
    private String remittanceIdentificationCode;


    @TableField("lending_party")
    @Schema(description="借款方")
    private String lendingParty;

    @TableField("lending_party_account")
    @Schema(description="借款方账户")
    private String lendingPartyAccount;

    @TableField("lending_party_bank")
    @Schema(description="借款方银行")
    private String lendingPartyBank;

    @TableField("lending_party_bank_code")
    @Schema(description="借款方银行行号")
    private String lendingPartyBankCode;

    @TableField("lending_party_open_bank")
    @Schema(description="借款方开户行")
    private String lendingPartyOpenBank;



    @TableField("payee")
    @Schema(description="收款方")
    private String payee;

    @TableField("payee_account")
    @Schema(description="收款账户")
    private String payeeAccount;

    @TableField("payee_bank")
    @Schema(description="收款银行")
    private String payeeBank;

    @TableField("payee_bank_code")
    @Schema(description="收款行号")
    private String payeeBankCode;

    @TableField("status")
    @Schema(description="10 待审批 15 待付款 20 审批通过   30 审批拒绝  40 付款中  50 付款成功 60 付款失败 ")
    private Integer status;

    @TableField("approve_time")
    @Schema(description="审批时间")
    private LocalDateTime approveTime;

    @TableField("approve_by")
    @Schema(description="审批人")
    private String approveBy;

    @TableField("reject_reason")
    @Schema(description="拒绝原因")
    private String rejectReason;

    @TableField("loan_repayment_time")
    @Schema(description="借款归还时间")
    private LocalDateTime loanRepaymentTime;


    @TableField("pay_channel")
    @Schema(description="支付渠道 1 订单支付 2 转账支付")
    private Integer payChannel;


    @TableField("close_order_time")
    @Schema(description="[转账支付]时有关单时间字段 yyyy-MM-dd HH:mm:ss")
    private String closeOrderTime;


    @TableField("create_by")
    @Schema(description="创建人")
    private String createBy;

    @TableField("create_time")
    @Schema(description="创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @Schema(description="修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
