package com.clx.performance.controller.pc.transport;


import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.clx.performance.component.ThirdComponent;
import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.dao.settle.SettlementDriverDetailDao;
import com.clx.performance.dao.settle.SettlementOwnerDetailDao;
import com.clx.performance.dto.InvoicingStatusNotifyDTO;
import com.clx.performance.dto.OrderChildSyncDTO;
import com.clx.performance.dto.PayStatusNotifyDTO;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.feign.TransportFeignService;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.model.settle.SettlementDriverDetail;
import com.clx.performance.model.settle.SettlementOwnerDetail;
import com.clx.performance.param.feign.transport.ThirdOrderChildBrokerParam;
import com.clx.performance.param.feign.transport.ThirdOrderChildRiskStatusDTO;
import com.clx.performance.service.TransportSyncService;
import com.clx.performance.service.settle.OrderChildSyncTransportRecordService;
import com.clx.performance.service.settle.SettlementOwnerService;
import com.msl.common.dto.HttpDTO;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping(value="/pc/transport/")
@Validated
@Tag(name = "PC-网络货运相关")
@AllArgsConstructor
public class TransportSyncController {


    private final TransportSyncService transportSyncService;

    private final OrderChildDao orderChildDao;

    private final SettlementOwnerDetailDao settlementOwnerDetailDao;

    private final OrderGoodsDao orderGoodsDao;

    private final TransportFeignService transportFeignService;

    private final SettlementDriverDetailDao settlementDriverDetailDao;

    private final OrderChildSyncTransportRecordService orderChildSyncTransportRecordService;

    private final SettlementOwnerService settlementOwnerService;

    private final OrderChildSyncTransportRecordService childSyncTransportRecordService;


    /**
     * 支付结果
     * @param param
     * @return
     */
    @Operation(summary = "payStatusNotify", description = "<br>By:胡宇帆")
    @PostMapping("/payStatusNotify")
    public Object payStatusNotify(@RequestBody String param) {
        HttpDTO bean = JSONUtil.toBean(param, HttpDTO.class);
        log.info("payStatusNotify 原始报文：{}", bean);
        String decrypt = ThirdComponent.decrypt(bean.getData());
        log.info("payStatusNotify 解密后：{}", decrypt);
        PayStatusNotifyDTO payStatusNotifyDTO = JSONUtil.toBean(decrypt, PayStatusNotifyDTO.class);
        log.info("支付回调payStatusNotifyDTO:{}", JSONUtil.parse(payStatusNotifyDTO));
        orderChildSyncTransportRecordService.updateStatus(payStatusNotifyDTO);
        return ThirdComponent.encrypt(JSON.toJSONString(Result.ok()));
    }

    /**
     * 开票结果
     * @param param
     * @return
     */
    @Operation(summary = "invoicingStatusNotify", description = "<br>By:胡宇帆")
    @PostMapping("/invoicingStatusNotify")
    public Object invoicingStatusNotify(@RequestBody String param) {
        HttpDTO bean = JSONUtil.toBean(param, HttpDTO.class);
        log.info("invoicingStatusNotify 原始报文：{}", bean);
        String decrypt = ThirdComponent.decrypt(bean.getData());
        log.info("invoicingStatusNotify 解密后：{}", decrypt);
        InvoicingStatusNotifyDTO invoicingStatusNotifyDTO = JSONUtil.toBean(decrypt, InvoicingStatusNotifyDTO.class);
        settlementOwnerService.invoicingStatusNotify(invoicingStatusNotifyDTO);
        return ThirdComponent.encrypt(JSON.toJSONString(Result.ok()));
    }

    /**
     * 风控结果
     * @param param
     * @return
     */
    @Operation(summary = "riskStatusNotify", description = "<br>By:艾庆国")
    @PostMapping("/riskStatusNotify")
    public Object riskStatusNotify(@RequestBody String param) {
        HttpDTO bean = JSONUtil.toBean(param, HttpDTO.class);
        log.info("riskStatusNotify 原始报文：{}", bean);
        String decrypt = ThirdComponent.decrypt(bean.getData());
        log.info("riskStatusNotify 解密后：{}", decrypt);
        ThirdOrderChildRiskStatusDTO invoicingStatusNotifyDTO = JSONUtil.toBean(decrypt, ThirdOrderChildRiskStatusDTO.class);

        return ThirdComponent.encrypt(JSON.toJSONString(Result.ok()));
    }
    @Operation(summary = "addOrderChildSyncTransportRecord", description = "<br>By:胡宇帆")
    @GetMapping("/addOrderChildSyncTransportRecord")
    public Result<Object> syncTest(@RequestParam("id") Integer id) {
        SettlementDriverDetail driverDetail = settlementDriverDetailDao.getEntityByKey(id).get();
        childSyncTransportRecordService.addOrderChildSyncTransportRecord(driverDetail);
        return Result.ok();
    }

    @Operation(summary = "syncTest", description = "<br>By:胡宇帆")
    @GetMapping("/syncTest")
    public Result<OrderChildSyncDTO> syncTest(@RequestParam String childNo) {
        OrderChild orderChild = orderChildDao.getByChildNo(childNo).get();
        OrderGoods orderGoods = orderGoodsDao.getByOrderGoodsNo(orderChild.getOrderGoodsNo()).get();
        SettlementOwnerDetail settlementOwnerDetail = settlementOwnerDetailDao.getByChildNo(childNo).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        SettlementDriverDetail settlementDriverDetail = settlementDriverDetailDao.getByChildNo(childNo).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        ThirdOrderChildBrokerParam param = transportSyncService.generateOrderChildSync(orderChild, orderGoods, settlementOwnerDetail, settlementDriverDetail);
        log.info("=======================生成Param{}", JSONUtil.parse(param));
        HttpDTO httpDTOResult = transportFeignService.orderChildSync(param);
        String decrypt = ThirdComponent.decrypt(httpDTOResult.getData());
        OrderChildSyncDTO bean = JSONUtil.toBean(decrypt, OrderChildSyncDTO.class);
        return Result.ok(bean);
    }


}
