package com.clx.performance.controller.pc.customer;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.customer.PageCustomerComplaintDetailParam;
import com.clx.performance.param.pc.customer.SaveCustomerComplaintDetailParam;
import com.clx.performance.service.customer.CustomerComplaintDetailService;
import com.clx.performance.vo.pc.customer.CustomerComplaintDetailVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @ClassName CustomerComplaintTypeController
 * @Description
 * @Author kavin
 * @Date 2023/12/7 10:44
 * @Version 1.0
 */

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/customer/complaint/type")
@Validated
@Tag(name = "客服-投诉详情")
@AllArgsConstructor
public class CustomerComplaintDetailController {

    private final CustomerComplaintDetailService customerComplaintDetailService;


    @Operation(summary = "保存客户投诉",description = "<br>By:刘海泉")
    @PostMapping("/saveCustomerComplaintDetail")
    public Result<Object> saveCustomerComplaintDetail(@RequestBody @Validated SaveCustomerComplaintDetailParam param){
        customerComplaintDetailService.saveCustomerComplaintDetail(param);
        return Result.ok();
    }


    @Operation(summary = "投诉详情列表",description = "<br>By:刘海泉")
    @PostMapping("/pageCustomerComplaintDetail")
    public Result<PageData<CustomerComplaintDetailVO>> pageCustomerComplaintDetail(@RequestBody @Validated PageCustomerComplaintDetailParam param){
        IPage<CustomerComplaintDetailVO> page = customerComplaintDetailService.pageCustomerComplaintDetail(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }



}
