package com.clx.performance.controller.pc.collect;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckLeaveParam;
import com.clx.performance.service.collect.CollectTruckLeaveService;
import com.clx.performance.vo.pc.collect.CollectTruckLeaveVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/driver/collect/leave")
@Validated
@Tag(name = "承运PC-请假")
@AllArgsConstructor
public class CarrierDriverCollectTruckLeaveController {

    private final CollectTruckLeaveService collectTruckLeaveService;

    @Operation(summary = "分页查询请假列表",description = "<br>By:艾庆国")
    @PostMapping("/pageLeave")
    public Result<PageData<CollectTruckLeaveVO>> pageLeave(@RequestBody @Validated CarrierPageCollectTruckLeaveParam param) {
        IPage<CollectTruckLeaveVO> page = collectTruckLeaveService.carrierPageLeave(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
