package com.clx.performance.controller.payment;

import com.clx.performance.enums.PayUnitTypeEnum;
import com.clx.performance.enums.payment.PayOperationStatusEnum;
import com.clx.performance.enums.payment.PaymentStatusEnum;
import com.clx.performance.model.payment.OrderPayment;
import com.clx.performance.param.pay.NotifyString;
import com.clx.performance.service.PaymentService;
import com.clx.performance.service.breakcontract.BreakContractMqHandlerService;
import com.clx.performance.service.settle.SettlementMqHandlerService;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import java.util.Objects;


@Slf4j
@RestController
@RequestMapping(value="/payment/notify")
@Validated
@Tag(name = "承运端-支付回调")
@AllArgsConstructor
public class PayNotifyController {
    @Autowired
    private SettlementMqHandlerService settlementMqHandlerService;

    @Autowired
    private BreakContractMqHandlerService breakContractMqHandlerService;

    @Autowired
    private PaymentService paymentService;




    @Operation(summary = "用户支付完成回调接口", description = " <br>By:胡宁宁")
    @RequestMapping(value = "/userPayNotify", method = RequestMethod.POST)
    public Result<Object> userPayNotify(@RequestBody NotifyString notify) {
        log.info("用户支付完成回调接口 传参 {}", notify);
        if (Objects.isNull(notify) || Objects.isNull(notify.getCode()) || Objects.isNull(notify.getAction())) {
            return new Result<>();
        }
        if (notify.getCode() != 0) {
            // 支付失败处理
            log.info("支付失败处理 唯一id {}", notify.getOrderNo());
            settlementMqHandlerService.settlementDriverNotify(notify.getOrderNo(),0,notify.getMsg());
        } else {
            // 支付支付成功处理
            log.info(" 支付支付成功处理 唯一id {}", notify.getOrderNo());
            settlementMqHandlerService.settlementDriverNotify(notify.getOrderNo(),1,notify.getMsg());
        }
        Result<Object> ret = new Result<>();
        return ret;
    }


    @Operation(summary = "用户支付完成回调接口", description = " <br>By:胡宁宁")
    @RequestMapping(value = "/userPayBrokerContractNotify", method = RequestMethod.POST)
    public Result<Object> userPayBrokerContractNotify(@RequestBody NotifyString notify) {
        log.info("用户支付完成回调接口 传参 {}", notify);
        if (Objects.isNull(notify) || Objects.isNull(notify.getCode()) || Objects.isNull(notify.getAction())) {
            return new Result<>();
        }
        if (notify.getCode() != 0) {
            breakContractMqHandlerService.payFail(notify.getOrderNo(), notify.getMsg());

            // 支付失败处理
            log.info("支付失败处理 唯一id {}", notify.getOrderNo());
        } else {

            breakContractMqHandlerService.paySuccess(notify.getOrderNo());

            // 支付支付成功处理
            log.info(" 支付支付成功处理 唯一id {}", notify.getOrderNo());
        }
        Result<Object> ret = new Result<>();
        return ret;
    }

    @Operation(summary = "司机冻结保证金回调接口", description = " <br>By:胡宁宁")
    @RequestMapping(value = "/userPayDriverFreezeNotify", method = RequestMethod.POST)
    public Result<Object> userPayDriverFreezeNotify(@RequestBody NotifyString notify) {
        log.info("司机冻结保证金回调接口 传参 {}", notify);
        if (Objects.isNull(notify) || Objects.isNull(notify.getCode()) || Objects.isNull(notify.getAction())) {
            return new Result<>();
        }
        String paymentItem = PayUnitTypeEnum.FREEZE_PLATFORM_FEE.getCode()+"";
        int operation = PayOperationStatusEnum.FREEZE.getValue();
        if (notify.getCode() != 0) {
            paymentService.updateOrderPaymentFail(notify.getOrderNo(), notify.getMsg(),
                    operation,
                    paymentItem
                   );
            // 支付失败处理
            log.info("支付失败处理 唯一id {}", notify.getOrderNo());
        } else {
            analysisSuccess(notify.getData().toString(), operation,  paymentItem);
            paymentService.updateOrderPaymentSuccess(notify.getOrderNo(), operation,
                    paymentItem);

            // 支付支付成功处理
            log.info(" 支付支付成功处理 唯一id {}", notify.getOrderNo());
        }
        Result<Object> ret = new Result<>();
        return ret;
    }

    @Operation(summary = "司机调整保证金回调接口", description = " <br>By:胡宁宁")
    @RequestMapping(value = "/userPayAdjustDriverFreezeNotify", method = RequestMethod.POST)
    public Result<Object> userPayAdjustDriverFreezeNotify(@RequestBody NotifyString notify) {
        log.info("司机调整保证金回调接口 传参 {}", notify);
        if (Objects.isNull(notify) || Objects.isNull(notify.getCode()) || Objects.isNull(notify.getAction())) {
            return new Result<>();
        }
        if (notify.getCode() != 0) {
            paymentService.updateOrderPaymentStatusById(notify.getOrderNo(),PaymentStatusEnum.FAIL.getValue());
            // 支付失败处理
            log.info("支付失败处理 唯一id {}", notify.getOrderNo());
            // 支付失败处理
        } else {
            paymentService.updateOrderPaymentStatusById(notify.getOrderNo(),PaymentStatusEnum.SUCCESS.getValue());

            // 支付支付成功处理
            log.info(" 支付支付成功处理 唯一id {}", notify.getOrderNo());
        }
        Result<Object> ret = new Result<>();
        return ret;
    }


    @Operation(summary = "司机取消运单退还保证金回调接口", description = " <br>By:胡宁宁")
    @RequestMapping(value = "/userPayCancelDriverFreezeNotify", method = RequestMethod.POST)
    public Result<Object> userPayCancelDriverFreezeNotify(@RequestBody NotifyString notify) {
        log.info("司机取消运单退还保证金回调接口 传参 {}", notify);
        if (Objects.isNull(notify) || Objects.isNull(notify.getCode()) || Objects.isNull(notify.getAction())) {
            return new Result<>();
        }
        String paymentItem = PayUnitTypeEnum.FREEZE_PLATFORM_FEE.getCode()+"";
        int operation = PayOperationStatusEnum.UNFREEZE.getValue();
        if (notify.getCode() != 0) {
            paymentService.updateOrderPaymentFail(notify.getOrderNo(), notify.getMsg(),
                    operation,
                    paymentItem
            );
            // 支付失败处理
            log.info("支付失败处理 唯一id {}", notify.getOrderNo());
        } else {
            paymentService.updateOrderPaymentSuccess(notify.getOrderNo(), operation,
                    paymentItem);

            // 支付支付成功处理
            log.info(" 支付支付成功处理 唯一id {}", notify.getOrderNo());
        }
        Result<Object> ret = new Result<>();
        return ret;
    }


    @Operation(summary = "运单完成 保证金回调接口", description = " <br>By:胡宁宁")
    @RequestMapping(value = "/userPayCompleteDriverFreezeNotify", method = RequestMethod.POST)
    public Result<Object> userPayCompleteDriverFreezeNotify(@RequestBody NotifyString notify) {
        log.info("运单完成 保证金回调接口 传参 {}", notify);
        if (Objects.isNull(notify) || Objects.isNull(notify.getCode()) || Objects.isNull(notify.getAction())) {
            return new Result<>();
        }
        String paymentItem = PayUnitTypeEnum.FREEZE_PLATFORM_FEE.getCode()+"";
        int operation = PayOperationStatusEnum.UNFREEZE.getValue();
        if (notify.getCode() != 0) {
            paymentService.updateOrderPaymentFail(notify.getOrderNo(), notify.getMsg(),
                    operation,
                    paymentItem
            );
            // 支付失败处理
            log.info("支付失败处理 唯一id {}", notify.getOrderNo());
        } else {
            paymentService.updateOrderPaymentSuccess(notify.getOrderNo(), operation,
                    paymentItem);

            // 支付支付成功处理
            log.info(" 支付支付成功处理 唯一id {}", notify.getOrderNo());
        }
        Result<Object> ret = new Result<>();
        return ret;
    }


    private void analysisSuccess(String result,Integer operation, String paymentItem){
        if(result.contains(",")){
            String[] stringFlag = result.split(",");
            if(stringFlag.length>0){
                //最多四笔，直接循环修改
                for(int i=0;i<stringFlag.length;i++){
                    String [] ress = stringFlag[i].split("=");
                    if(ress.length==2){//例如 id=serialNo
                        paymentService.updateOrderPaymentSerialNoSuccess(ress[0],ress[1],operation,paymentItem);
                    }
                }
            }
        }else{
            String[] ress = result.split("=");
            if(ress.length==2){//例如 id=serialNo
                paymentService.updateOrderPaymentSerialNoSuccess(ress[0],ress[1],operation,paymentItem);
            }
        }
    }

}
