package com.clx.performance.model.export;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

@Getter
@Setter
@Accessors(chain = true)
@TableName("export_template")
public class ExportTemplate implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("export_function_code")
    @ApiModelProperty("功能code")
    private String exportFunctionCode;

    @TableField("name")
    @ApiModelProperty("模板名称")
    private String name;

    @TableField("remark")
    @ApiModelProperty("描述")
    private String remark;

    @TableField("default_flag")
    @ApiModelProperty("是否默认：1是，0否")
    private Integer defaultFlag;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
        return this.id;
    }
}
