package com.clx.performance.model.loan;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("owner_payment")
public class OwnerPayment implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("owner_user_no")
    @ApiModelProperty("货主编码")
    private Long ownerUserNo;

    @TableField("owner_user_name")
    @ApiModelProperty("货主名称")
    private String ownerUserName;

    @TableField("mobile")
    @ApiModelProperty("联系电话")
    private String mobile;

    @TableField("running_water_open_no")
    @ApiModelProperty("交易流水号（第三方）")
    private String runningWaterOpenNo;

    @TableField("merchant_running_water_no")
    @ApiModelProperty("商户流水")
    private String merchantRunningWaterNo;

    @TableField("payment_no")
    @ApiModelProperty("付款单号")
    private Long paymentNo;

    @TableField("repayment_no")
    @ApiModelProperty("还款单号")
    private Long repaymentNo;

    @TableField("payment_balance")
    @ApiModelProperty("付款金额")
    private BigDecimal paymentBalance;

    @TableField("payment")
    @ApiModelProperty("付款方")
    private String payment;

    @TableField("payment_account")
    @ApiModelProperty("付款账户")
    private String paymentAccount;

    @TableField("payee")
    @ApiModelProperty("收款方")
    private String payee;

    @TableField("payee_account")
    @ApiModelProperty("收款账户")
    private String payeeAccount;

    @TableField("payee_bank_code")
    @ApiModelProperty("收款银行行号")
    private String payeeBankCode;

    @TableField("status")
    @ApiModelProperty("10 待付款 40 付款中 50 付款成功 60 付款失败")
    private Integer status;

    @TableField("pay_channel")
    @ApiModelProperty("默认财资")
    private Integer payChannel;

    @TableField("operate_time")
    @ApiModelProperty("操作时间")
    private LocalDateTime operateTime;

    @TableField("operate_by")
    @ApiModelProperty("操作人")
    private String operateBy;

    @TableField("create_by")
    @ApiModelProperty("创建人")
    private String createBy;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
