package com.clx.performance.mapper.vehiclewarn;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.vehiclewarn.VehicleWarnInfo;
import com.clx.performance.param.pc.vehiclewarn.PageVehicleWarnInfoParam;
import com.clx.performance.sqlProvider.vehiclewarn.VehicleWarnInfoSqlProvider;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

@Mapper
public interface VehicleWarnInfoMapper extends BaseMapper<VehicleWarnInfo> {
    String TABLE = "vehicle_warn_info";

    /**
     * @see VehicleWarnInfoSqlProvider#pageByParam(Page, PageVehicleWarnInfoParam)
     */
    @SelectProvider(type = VehicleWarnInfoSqlProvider.class, method = "pageByParam")
    IPage<VehicleWarnInfo> pageByParam(@Param("page") Page page, @Param("param") PageVehicleWarnInfoParam param);
}