package com.clx.performance.param.app;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class OrderChildUnloadParam extends PositionParam {

    @ApiModelProperty(value = "运单编号", example = "100000000")
    @NotBlank(message = "运单编号不能为空")
    private String childNo;

    @ApiModelProperty(value = "卸货毛重（单位吨）", example = "2.46")
    private BigDecimal unloadRough;

    @ApiModelProperty(value = "卸货皮重（单位吨）", example = "1.23")
    private BigDecimal unloadTare;

    @ApiModelProperty(value = "磅单图片列表")
    @NotEmpty(message = "请上传磅单照片")
    private List<String> unloadImageList;

    @ApiModelProperty(value = "交货时间")
    @NotBlank(message = "交货时间不能为空")
    private String unloadTime;

}
