/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.communication.pool;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class SocketConnectionPool {
    public static final String SERVER_IP = "ip";
    public static final String SERVER_PORT = "port";
    public static final String MAX_CONN_NUMBER = "maxconn";
    public static final String WAIT_TIMEOUT = "timeout";
    private static Properties properties = null;
    private static SocketConnectionPool instance = null;
    private int maxConnections = 10;
    private int usedConnections = 0;
    private int timeout = 0;
    private String host = null;
    private int port = 0;
    private List socketList = null;
    private Object syncObj = new Object();

    static {
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
    }

    public int size() {
        return this.socketList == null ? 0 : this.socketList.size();
    }

    private SocketConnectionPool(Properties prop) {
        if (prop.containsKey(WAIT_TIMEOUT)) {
            this.timeout = Integer.parseInt(prop.getProperty(WAIT_TIMEOUT));
        }
        if (prop.containsKey(MAX_CONN_NUMBER)) {
            this.maxConnections = Integer.parseInt(prop.getProperty(MAX_CONN_NUMBER));
        }
        if (prop.containsKey(SERVER_IP)) {
            this.host = prop.getProperty(SERVER_IP);
        }
        if (prop.containsKey(SERVER_PORT)) {
            this.port = Integer.parseInt(prop.getProperty(SERVER_PORT));
        }
        this.socketList = new ArrayList(this.maxConnections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeConnection(Socket socket) {
        Object object = this.syncObj;
        synchronized (object) {
            this.socketList.add(socket);
            --this.usedConnections;
            try {
                this.syncObj.notifyAll();
            }
            catch (IllegalMonitorStateException e) {
                e.printStackTrace();
            }
        }
    }

    private void release() {
        this.socketList.clear();
    }

    public static void setProperties(Properties prop) {
        properties = prop;
    }

    private static synchronized SocketConnectionPool getInstance() {
        if (instance == null) {
            instance = new SocketConnectionPool(properties);
        }
        return instance;
    }

    private Socket newConnection() throws IOException {
        try {
            return new PoolSocket(this.host, this.port);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof NullPointerException) {
                throw new IOException("Create Socket Failed");
            }
            throw new IOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket getConnection() throws InterruptedException, IOException {
        Socket socket = null;
        Object object = this.syncObj;
        synchronized (object) {
            while (this.maxConnections > 0 && this.usedConnections >= this.maxConnections) {
                this.syncObj.wait();
            }
            socket = this.socketList.size() > 0 ? (PoolSocket)this.socketList.remove(this.socketList.size() - 1) : this.newConnection();
            ++this.usedConnections;
        }
        return socket;
    }

    class PoolSocket
    extends Socket {
        public PoolSocket(String host, int port) throws IOException {
            super(host, port);
            this.setSoTimeout(SocketConnectionPool.this.timeout);
            this.setTcpNoDelay(true);
        }

        public void close() {
            SocketConnectionPool.this.freeConnection(this);
        }
    }

    private static class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        public void run() {
            if (instance != null) {
                instance.release();
            }
        }
    }
}

