/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.basic;

import cn.com.infosec.netsign.agent.basic.SocketHandler;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;

public class ShortConnectionSocketHandler
implements SocketHandler {
    private SocketAddress sa;
    int connTimeout;
    int soTimeout;

    public ShortConnectionSocketHandler(SocketAddress sa, int connTimeout, int soTimeout) {
        this.sa = sa;
        this.connTimeout = connTimeout;
        this.soTimeout = soTimeout;
    }

    public Socket getSocket() throws IOException {
        return new Socket();
    }

    public Socket newSocket() throws IOException {
        Socket socket = new Socket();
        try {
            socket.setSoTimeout(this.soTimeout);
            socket.setTcpNoDelay(true);
            socket.setSoLinger(true, 0);
            socket.connect(this.sa, this.connTimeout);
            return socket;
        }
        catch (Exception ioEx) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ConsoleLogger.logException(ioEx);
            ConsoleLogger.logException(ioEx, "Connect to " + this.sa + " failed");
            throw new IOException(ioEx.toString());
        }
    }

    public void close(Socket s) {
        this.forceClose(s);
    }

    public void forceClose(Socket s) {
        try {
            s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

