package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.PendingFreightDao;
import com.clx.performance.mapper.PendingFreightMapper;
import com.clx.performance.model.PendingFreight;
import com.clx.performance.param.pc.PagePendingFreightParam;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author kavin
 * Date 2024-10-17
 * Time 19:37
 */
@Repository
public class PendingFreightDaoImpl extends BaseDaoImpl<PendingFreightMapper, PendingFreight, Integer> implements PendingFreightDao {
    @Override
    public long updateInternalReportData(String orderNo, String name, BigDecimal logisticsFreight) {
        LambdaUpdateWrapper<PendingFreight> update = new LambdaUpdateWrapper<>();
        update.set(StringUtils.isNotBlank(name),PendingFreight :: getSeniorLogisticsManagerName,name);
        update.set(Objects.nonNull(logisticsFreight),PendingFreight :: getLogisticsFreight,logisticsFreight);
        update.eq(PendingFreight :: getOrderNo,orderNo);
        return baseMapper.update(update);
    }

    @Override
    public void updateOrderedAndLoadTruckRate(String orderNo, BigDecimal orderedRate, BigDecimal loadTruckRate) {
        LambdaUpdateWrapper<PendingFreight> update = new LambdaUpdateWrapper<>();
        update.set(PendingFreight :: getOrderedRate,orderedRate);
        update.set(PendingFreight :: getLoadTruckRate,loadTruckRate);
        update.eq(PendingFreight :: getOrderNo,orderNo);
        baseMapper.update(update);
    }

    @Override
    public IPage<PendingFreight> pagePendingFreight(PagePendingFreightParam param) {
        LambdaQueryWrapper<PendingFreight> query = new LambdaQueryWrapper<>();
        query.orderByDesc(PendingFreight :: getId);
        return baseMapper.selectPage(Page.of(param.getPage(),param.getPageSize()),query);
    }
}
