package com.clx.performance.controller.pc.breakcontract.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.breakcontract.carrier.BatchUpdatePayDriverBreakContractSettlementParam;
import com.clx.performance.param.pc.breakcontract.carrier.PageCarrierBreakContractSettlementDriverParam;
import com.clx.performance.service.breakcontract.BreakContractSettlementDriverService;
import com.clx.performance.vo.pc.breakcontract.carrier.CarrierBreakContractSettlementDriverDetailVO;
import com.clx.performance.vo.pc.breakcontract.carrier.PageCarrierBreakContractSettlementDriverVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotBlank;


@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/breakContract")
@Validated
@Tag(name = "承运端-违约结算单（车主）")
@AllArgsConstructor
public class CarrierBreakContractSettlementDriverController {

    private final BreakContractSettlementDriverService breakContractSettlementDriverService;


    @Operation(summary = "列表",description = "<br>By:李瑞新")
    @PostMapping("/pageCarrierBreakContractSettlementDriverList")
    @UnitCovert(param = false)
    public Result<PageData<PageCarrierBreakContractSettlementDriverVO>> pageCarrierBreakContractSettlementDriverList(@RequestBody PageCarrierBreakContractSettlementDriverParam param) {
        IPage<PageCarrierBreakContractSettlementDriverVO> page = breakContractSettlementDriverService.pageCarrierBreakContractSettlementDriverList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @Operation(summary = "导出",description = "<br>By:李瑞新")
    @PostMapping("/exportCarrierBreakContractSettlementDriverList")
    public Result exportCarrierBreakContractSettlementDriverList(@RequestBody  PageCarrierBreakContractSettlementDriverParam param, HttpServletResponse response) throws Exception {

        SXSSFWorkbook workbook = breakContractSettlementDriverService.exportCarrierBreakContractSettlementDriverList(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        workbook.write(response.getOutputStream());
        return null;
    }

    @Operation(summary = "详情",description = "<br>By:李瑞新")
    @GetMapping("/getCarrierBreakContractSettlementDriverDetail")
    @UnitCovert(param = false)
    public Result<CarrierBreakContractSettlementDriverDetailVO> getCarrierBreakContractSettlementDriverDetail(@NotBlank(message = "结算单号不能为空") String settlementNo) {
        return Result.ok(breakContractSettlementDriverService.getDetailBySettlementNo(settlementNo));
    }


    @Operation(summary = "批量结算车主违约结算单",description = "<br>By:刘海泉")
    @PostMapping("/updateBatchPayDriverBreakContractSettlement")
    public Result<Object> updateBatchPayDriverBreakContractSettlement(@RequestBody @Validated BatchUpdatePayDriverBreakContractSettlementParam param) {
        breakContractSettlementDriverService.updateBatchPayDriverBreakContractSettlement(param);
        return Result.ok();
    }

}
