package com.clx.performance.dao.impl.linewarn;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.linewarn.LineWarnConfigDao;
import com.clx.performance.enums.linewarn.LineWarnConfigEnum;
import com.clx.performance.mapper.linewarn.LineWarnConfigMapper;
import com.clx.performance.model.linewarn.LineWarnConfig;
import com.clx.performance.param.pc.linewarn.PageLineWarnConfigParam;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class LineWarnConfigDaoImpl extends BaseDaoImpl<LineWarnConfigMapper, LineWarnConfig, Integer> implements LineWarnConfigDao {

    @Override
    public boolean updateConfig(LineWarnConfig item) {
        return update(lUdWrapper()
                .eq(LineWarnConfig::getId, item.getId())
                .set(LineWarnConfig::getWarnName, item.getWarnName())
                .set(LineWarnConfig::getWarnType, item.getWarnType())
                .set(LineWarnConfig::getWarnLevel, item.getWarnLevel())

                .set(LineWarnConfig::getInterval, item.getInterval())
                .set(LineWarnConfig::getTimeRatio, item.getTimeRatio())
                .set(LineWarnConfig::getTaskCompleteRatio, item.getTaskCompleteRatio())
        );
    }

    @Override
    public boolean updateStatus(LineWarnConfig item) {
        return update(lUdWrapper()
                .eq(LineWarnConfig::getId, item.getId())
                .set(LineWarnConfig::getStatus, item.getStatus())
        );
    }

    @Override
    public boolean updateDelete(LineWarnConfig item) {
        return update(lUdWrapper()
                .eq(LineWarnConfig::getId, item.getId())
                .set(LineWarnConfig::getDeleteStatus, item.getDeleteStatus())
        );
    }

    @Override
    public Optional<LineWarnConfig> findById(Integer id) {
        return Optional.of(id)
                .map(item -> lQrWrapper()
                        .eq(LineWarnConfig::getId, id)
                        .eq(LineWarnConfig::getDeleteStatus, LineWarnConfigEnum.DeleteStatus.NO.getCode())
                        .last("limit 1")
                )
                .map(super::getOne);
    }

    @Override
    public Optional<LineWarnConfig> findByName(String name) {
        return Optional.of(name)
                .map(item -> lQrWrapper()
                        .eq(LineWarnConfig::getWarnName, name)
                        .eq(LineWarnConfig::getDeleteStatus, LineWarnConfigEnum.DeleteStatus.NO.getCode())
                        .last("limit 1")
                )
                .map(super::getOne);
    }

    @Override
    public List<LineWarnConfig> listByWarnType(Integer warnType) {
        return list(lQrWrapper()
                .eq(LineWarnConfig::getWarnType, warnType)
                .eq(LineWarnConfig::getDeleteStatus, LineWarnConfigEnum.DeleteStatus.NO.getCode())
                .eq(LineWarnConfig::getStatus, LineWarnConfigEnum.Status.ENABLE.getCode())
        );
    }

    @Override
    public IPage<LineWarnConfig> pageByParam(PageLineWarnConfigParam param) {
        Page<LineWarnConfig> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageByParam(page,param);
    }

}
