package com.clx.performance.sqlProvider.linewarn;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.enums.linewarn.LineWarnInfoEnum;
import com.clx.performance.param.pc.linewarn.PageLineWarnInfoParam;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

import java.util.Objects;

public class LineWarnInfoSqlProvider {

    private static final String TABLE = "line_warn_info";

    public String pageByParam(@Param("page") Page page, @Param("param") PageLineWarnInfoParam param) {

        return new SQL(){{

            SELECT("*");
            FROM(TABLE);
            if (StringUtils.isNotBlank(param.getWarnName())) {WHERE("warn_name like CONCAT('%', #{param.warnName},'%')");}
            if (StringUtils.isNotBlank(param.getOrderGoodsNo())) {WHERE("order_goods_no = #{param.orderGoodsNo}");}
            if (Objects.nonNull(param.getWarnType())) {WHERE("warn_type = #{param.warnType}");}
            if (Objects.nonNull(param.getWarnLevel())) {WHERE("warn_level = #{param.warnLevel}");}
            if (Objects.nonNull(param.getStatus())) {

                if (Objects.equals(param.getStatus(), LineWarnInfoEnum.Status.RESOLVE.getCode())) {
                    WHERE("status = #{param.status}");
                }
                else if (Objects.equals(param.getStatus(), LineWarnInfoEnum.Status.INIT.getCode())) {
                    WHERE("(status = 1 and (suspend_time is null or suspend_time < now()))");
                }
                else {
                    WHERE("(status = 1 and(suspend_time is not null and suspend_time > now()))");
                }

            }

            if (StringUtils.isNotBlank(param.getSendAddress())) {WHERE("send_address like CONCAT('%',#{param.sendAddress},'%')");}
            if (StringUtils.isNotBlank(param.getReceiveAddress())) {WHERE("receive_address like CONCAT('%',#{param.receiveAddress},'%')");}

            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("warn_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("warn_time <= #{param.endTime}");}

            ORDER_BY("warn_time desc, id desc");
        }}.toString();
    }

}
