package com.clx.performance.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.model.OwnerTransferInfo;
import com.clx.performance.param.app.CheckMobileParam;
import com.clx.performance.param.app.InformationParam;
import com.clx.performance.param.app.ResetPasswordParam;
import com.clx.performance.param.app.SendMobileCaptchaParam;
import com.clx.performance.param.open.OpenOwnerBindCardParam;
import com.clx.performance.param.open.OpenOwnerCaseOutParam;
import com.clx.performance.param.open.OpenOwnerTopUpParam;
import com.clx.performance.param.pc.*;
import com.clx.performance.param.pc.owner.CreteAccountParam;
import com.clx.performance.param.pc.owner.FrozenAccountParam;
import com.clx.performance.param.pc.owner.ThawAccountParam;
import com.clx.performance.vo.pc.*;
import com.clx.user.param.pc.owner.UpdateOwnerBindCardFeignParam;
import com.clx.user.vo.pc.owner.OwnerBindCardVO;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public interface OwnerAccountService {
    IPage<OwnerAccountVO> pageList(PageOwnerAccountListParam param);

    IPage<OwnerAccountRunningWaterRecordVO> marginAccountPageList(PagePlatformMarginAccountParam param);

    IPage<OwnerAccountRunningWaterRecordVO> prepaidFreightAccountPageList(PagePlatformPrepaidFreightAccountParam param);

    IPage<OwnerAccountRunningWaterRecordVO> prepaidFreightOwnerAccountPageList(PageAppPrepaidFreightAccountParam param);


    OwnerAccountAllVO accountInfo(Long ownerUserNo);

    Long accountTopUp(OwnerTopUpParam param);

    Long openAccountTopUp(OpenOwnerTopUpParam param);

    Long accountCaseOut(OwnerCaseOutParam param);

    Long openAccountCaseOut(OpenOwnerCaseOutParam param);

    /**
     * 充值审批
     */
    void accountTopUpApprove(PlatformAccountTopUpParam param);

    /**
     * 提现审批
     * @param param
     */
    void accountCaseOutApprove(OwnerCaseOutApproveParam param);

    /**
     * 货主付款确认
     * @param id
     */
    void accountBalanceConfirm(Integer id);

    /**
     *保证金导出
     * @param param
     * @return
     */
    SXSSFWorkbook exportMarginAccountPageList(PagePlatformMarginAccountParam param);

    /**
     * 预付金导出
     * @param param
     * @return
     */
    SXSSFWorkbook exportPrepaidFreightAccountPageList(PagePlatformPrepaidFreightAccountParam param);

    OwnerTransferInfo transferPublic();

    OwnerBindCardVO getOwnerBindCard(Long userNo);

    void bindOwnerBindCard(OwnerBindCardParam param);

    void openBindOwnerBindCard(OpenOwnerBindCardParam param);


    void unBindOwnerBindCard(OwnerBindCardParam param);

    void openUnBindOwnerBindCard(OpenOwnerBindCardParam param);


    void ownerAccountFrozen(FrozenAccountParam param);

    void createAccount(CreteAccountParam param);

    void ownerAccountThaw(ThawAccountParam param);

    String checkMobile(CheckMobileParam param);

    String sendMobileCaptcha(SendMobileCaptchaParam param);

    String checkBusinessLicenseNumber(InformationParam param);

    void resetPassword(ResetPasswordParam param);

    OwnerLoanAccountVO loanAccount(Long userNo);

    OwnerAccountAllVO accountAllInfo(Long userNo);

    OwnerAccountArrearsVO accountArrearsInfo(Long userNo, BigDecimal prepaidArrearsOrder, BigDecimal marginArrearsOrder);
}
