package com.clx.performance.service.impl.linewarn;

import com.clx.performance.dao.linewarn.LineWarnInfoDao;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.model.linewarn.LineWarnConfig;
import com.clx.performance.model.linewarn.LineWarnInfo;
import com.clx.performance.service.linewarn.LineWarnCommonService;
import com.clx.performance.service.linewarn.LineWarnMqService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Slf4j
@Service
public class LineWarnCommonServiceImpl implements LineWarnCommonService {
    private final static int MIN_FER_HOUR = 60;

    @Autowired
    private LineWarnInfoDao lineWarnInfoDao;
    @Autowired
    private LineWarnMqService lineWarnMqService;

    @Override
    public void lineWarnInfoUpdate(OrderGoods orderGoods, LineWarnInfo lineWarnInfo, LineWarnConfig lineWarnConfig){

        lineWarnInfoUpdate(orderGoods, lineWarnInfo, lineWarnConfig, null);
    }
    @Override
    public void lineWarnInfoUpdate(OrderGoods orderGoods, LineWarnInfo lineWarnInfo, LineWarnConfig lineWarnConfig, String weather){

        // 更新
        if (lineWarnInfo != null){

            // 计算下次生效时间
            LocalDateTime nextTime = lineWarnInfo.getWarnTime().plusMinutes(lineWarnConfig.getInterval().multiply(new BigDecimal(MIN_FER_HOUR)).intValue());
            if (nextTime.isAfter(LocalDateTime.now())) {return;}

            lineWarnInfo.setWeather(weather);
            lineWarnInfo.setWarnTime(LocalDateTime.now());
            lineWarnInfoDao.updateWarnTime(lineWarnInfo);

            // 发送mq （预警通知）
            lineWarnMqService.lineWarnNotice(lineWarnInfo.getId());
            return;
        }

        // 新增
        lineWarnInfo = new LineWarnInfo();
        lineWarnInfo.setWarnConfigId(lineWarnConfig.getId());
        lineWarnInfo.setWarnType(lineWarnConfig.getWarnType());
        lineWarnInfo.setWarnName(lineWarnConfig.getWarnName());
        lineWarnInfo.setWarnLevel(lineWarnConfig.getWarnLevel());

        lineWarnInfo.setOrderGoodsNo(orderGoods.getOrderGoodsNo());
        lineWarnInfo.setSendAddressId(orderGoods.getSendAddressId());
        lineWarnInfo.setSendAddress(orderGoods.getSendAddressShorter());
        lineWarnInfo.setReceiveAddressId(orderGoods.getReceiveAddressId());
        lineWarnInfo.setReceiveAddress(orderGoods.getReceiveAddressShorter());

        lineWarnInfo.setWeather(weather);
        lineWarnInfo.setWarnTime(LocalDateTime.now());

        lineWarnInfoDao.saveEntity(lineWarnInfo);
        // 发送mq （预警通知）
        lineWarnMqService.lineWarnNotice(lineWarnInfo.getId());
    }

}
