package com.clx.performance.job.linewarn;

import com.clx.performance.dao.linewarn.LineWarnOrderGoodsDao;
import com.clx.performance.model.linewarn.LineWarnOrderGoods;
import com.clx.performance.service.linewarn.LineWarnMqService;
import com.msl.common.job.JobLog;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@Component
public class LineWarnJob {

    @Autowired
    private LineWarnOrderGoodsDao lineWarnOrderGoodsDao;
    @Autowired
    private LineWarnMqService lineWarnMqService;

    /**
     * 线路监控预警
     */
    @XxlJob("lineWarnWarn")
    public void lineWarnWarn() {

        try {

            List<LineWarnOrderGoods> list = lineWarnOrderGoodsDao.ListOrderGoodsNoOfWarn();
            log.info("线路监控预警, size:{}", list.size());

            for (LineWarnOrderGoods item : list) {

                LocalDateTime now = LocalDateTime.now();
                LocalDateTime beginTime = now.minusSeconds(600);

                // 发送mq (线路预警)
                lineWarnMqService.lineWarn(item.getOrderGoodsNo());
            }

        } catch (Exception e) {
            log.warn("线路监控预警失败，异常原因:{}", ExceptionUtils.getStackTrace(e));
            JobLog.error("线路监控预警失败，异常原因=====================", e);
        }

    }

}
