package com.clx.performance.dao.impl.settle;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.settle.SettlementDriverDao;
import com.clx.performance.enums.loan.OwnerLoanRecordEnum;
import com.clx.performance.mapper.settle.SettlementDriverMapper;
import com.clx.performance.model.settle.SettlementDriver;
import com.clx.performance.param.pc.driver.PageCarrierSettlementDriverParam;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Objects;
import java.util.Set;

/**
 * @Author: aiqinguo
 * @Description: 车主结算单
 * @Date: 2023-10-11 18:04:09
 * @Version: 1.0
 */
@Repository
public class SettlementDriverDaoImpl extends BaseDaoImpl<SettlementDriverMapper, SettlementDriver, Integer> implements SettlementDriverDao {



    @Override
    public IPage<SettlementDriver> pageCarrierSettlementDriver(PageCarrierSettlementDriverParam param) {
        LambdaQueryWrapper<SettlementDriver> query = new LambdaQueryWrapper<>();

        if(StringUtils.isNotBlank(param.getChildNo())){
            query.eq(SettlementDriver :: getChildNo,param.getChildNo());
        }
        if(StringUtils.isNotBlank(param.getOrderGoodsNo())){
            query.eq(SettlementDriver :: getOrderGoodsNo,param.getOrderGoodsNo());
        }
        if(StringUtils.isNotBlank(param.getStatus())){
            query.eq(SettlementDriver :: getStatus,param.getStatus());
        }
        if(Objects.nonNull(param.getDriverUserNo())){
            query.eq(SettlementDriver :: getDriverUserNo,param.getDriverUserNo());
        }
        if(StringUtils.isNotBlank(param.getDriverUserName())){
            query.like(SettlementDriver :: getDriverName,param.getDriverUserName());
        }

        query.orderByDesc(SettlementDriver :: getCreateTime);
        return baseMapper.selectPage(Page.of(param.getPage(),param.getPageSize()),query);
    }

    @Override
    public Optional<SettlementDriver> getByChildNo(String childNo) {
        return Optional.of(childNo)
                .map(item -> lQrWrapper()
                        .eq(SettlementDriver::getChildNo, item)
                )
                .map(super::getOne);
    }

    @Override
    public void updateLoanFlagByChildNoList(List<String> childNoList) {
        update(lUdWrapper().in(SettlementDriver::getChildNo, childNoList)
                .set(SettlementDriver::getLoanFlag, OwnerLoanRecordEnum.LoanFlag.RE_PAY.getCode())
        );
    }

    @Override
    public void updateStatus(Integer id,Integer status) {
        update(lUdWrapper().eq(SettlementDriver::getId, id)
                .set(SettlementDriver::getStatus, status)
        );
    }

    @Override
    public void updatePayErrorMsg(Integer id,String payErrorMsg) {
        update(lUdWrapper().eq(SettlementDriver::getId, id)
                .set(SettlementDriver::getPayErrorMsg, payErrorMsg)
        );
    }
}
