package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.IntegralTruckDao;
import com.clx.performance.mapper.IntegralTruckMapper;
import com.clx.performance.model.IntegralTruck;
import com.clx.performance.param.app.integral.DriverPageIntegralTruckRankParam;
import com.clx.performance.param.pc.PageIntegralTruckRankParam;
import com.clx.performance.param.pc.PageIntegralTruckParam;
import com.clx.performance.vo.pc.IntegralTruckVO;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author: aiqinguo
 * @Description: 积分车辆
 * @Date: 2023-10-9 12:00:54
 * @Version: 1.0
 */
@Repository
public class IntegralTruckDaoImpl extends BaseDaoImpl<IntegralTruckMapper, IntegralTruck, Integer> implements IntegralTruckDao {

    @Override
    public boolean updateIntegral(IntegralTruck item) {
        return update(lUdWrapper()
                .eq(IntegralTruck::getId, item.getId())
                .set(IntegralTruck::getIntegral, item.getIntegral())
        );
    }

    @Override
    public boolean updateIntegralByTruckNo(String truckNo, Integer integral) {
        return update(lUdWrapper()
                .eq(IntegralTruck::getTruckNo, truckNo)
                .set(IntegralTruck::getIntegral, integral)
        );
    }

    @Override
    public boolean existByTruckNo(String truckNo) {
        return baseMapper.existByTruckNo(truckNo)>0;
    }

    @Override
    public IPage<IntegralTruckVO> pageByParam(PageIntegralTruckParam param) {
        return baseMapper.pageByParam(Page.of(param.getPage(), param.getPageSize()), param);

    }

    @Override
    public long countByTruckEchelon(Integer truckEchelon) {
        return count(lQrWrapper()
                .eq(IntegralTruck::getEchelon, truckEchelon)
        );
    }

    @Override
    public Optional<IntegralTruck> getByTruckNo(String truckNo) {
        return Optional.of(truckNo)
                .map(item -> lQrWrapper()
                        .eq(IntegralTruck::getTruckNo, item)
                )
                .map(super::getOne);
    }

    @Override
    public List<IntegralTruck> listByTruckNoList(List<String> truckNoList) {
        return list(lQrWrapper().in(IntegralTruck::getTruckNo, truckNoList));
    }

    @Override
    public IPage<IntegralTruckVO> pageTruckRank(PageIntegralTruckRankParam param) {
        return baseMapper.pageTruckRank(Page.of(param.getPage(), param.getPageSize()));
    }

    @Override
    public IPage<IntegralTruckVO> driverPageTruckRank(DriverPageIntegralTruckRankParam param) {
        return baseMapper.driverPageTruckRank(Page.of(param.getPage(), param.getPageSize()), param);
    }

    @Override
    public List<IntegralTruck> selectListByTime(String beginTime, String endTime) {
        return list(lQrWrapper()
                .ge(IntegralTruck::getCreateTime, beginTime)
                .lt(IntegralTruck::getCreateTime, endTime));
    }

}
