package com.clx.performance.controller.temp;

import com.clx.performance.service.linewarn.LineWarnMqService;
import com.msl.common.result.Result;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author: aiqingguo
 * @Description: 临时接口
 * @Date: 2023-8-21 12:10:16
 * @Version: 1.0
 */
@Slf4j
@RestController
@RequestMapping(value="/temp/lineWarn")
public class TempLineWarnController {

    @Autowired
    private LineWarnMqService lineWarnMqService;

    @ApiOperation(value = "test", notes = "<br>By:艾庆国")
    @PostMapping("/test")
    public Result test() {

        return Result.ok();
    }

    @ApiOperation(value = "运单异常", notes = "<br>By:艾庆国")
    @PostMapping("/orderChildWarn")
    public Result orderChildWarn(String orderGoodsNo, String childNo) {

        lineWarnMqService.orderChildWarn(orderGoodsNo, childNo);
        return Result.ok();
    }

    @ApiOperation(value = "货单新增", notes = "<br>By:艾庆国")
    @PostMapping("/orderGoodsAdd")
    public Result orderGoodsAdd(String orderGoodsNo) {

        lineWarnMqService.orderGoodsAdd(orderGoodsNo);
        return Result.ok();
    }

}
