package com.clx.performance.vo.pc.linewarn;

import com.clx.performance.enums.OrderChildEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;


@Getter
@Setter
@NoArgsConstructor
public class LineWarnTruckTraceInfoVO {

        @ApiModelProperty(value = "运单编号", example = "100000")
        private String childNo;
        @ApiModelProperty(value = "车牌号", example = "京A12345")
        private String truckNo;
        @ApiModelProperty(value = "司机用户编号", example = "100000")
        private Long driverUserNo;
        @ApiModelProperty(value = "司机姓名", example = "张三")
        private String driverName;
        @ApiModelProperty(value = "司机手机号", example = "13000000000")
        private String driverMobile;
        @ApiModelProperty(value = "车辆状态：1空车 2重车", example = "1")
        private Integer truckStatus;
        @ApiModelProperty(value = "运单状态", example = "1")
        private Integer status;
        @ApiModelProperty(value = "运单状态", example = "1")
        private String statusMsg;
        public String getStatusMsg() {
                return OrderChildEnum.Status.getMsgByCode(status);
        }
        @ApiModelProperty("经度")
        private BigDecimal longitude;
        @ApiModelProperty("纬度")
        private BigDecimal latitude;

}