package com.clx.performance.param.app;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class SendMobileCaptchaParam {

    @ApiModelProperty(value = "手机号", example = "1")
    @NotBlank(message = "手机号")
    private String mobile;

    @ApiModelProperty(value = "会话ID", required = true, example = "XXX", dataType = "String")
    private String sessionId;
    @ApiModelProperty(value = "签名串", required = true, example = "XXX", dataType = "String")
    private String sig;
    @ApiModelProperty(value = "请求唯一标识", required = true, example = "XXX", dataType = "String")
    private String token;
    @ApiModelProperty(value = "场景标识", required = true, example = "XXX", dataType = "String")
    private String scene;

}
