package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

@Getter
@AllArgsConstructor
public enum OrderGoodsOverWeightEnum {

    NO(0, "否"),
    YES(1, "是"),
    ;

    private final Integer code;
    private final String name;

    public static Optional<OrderGoodsOverWeightEnum> getByCode(Integer code) {
        return Arrays.stream(values()).filter(e -> e.code .equals(code)).findFirst();
    }


}
