/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.x509;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.GeneralName;
import cn.com.infosec.asn1.x509.GeneralNames;
import cn.com.infosec.asn1.x509.Holder;
import cn.com.infosec.asn1.x509.IssuerSerial;
import cn.com.infosec.asn1.x509.ObjectDigestInfo;
import cn.com.infosec.jce.PrincipalUtil;
import cn.com.infosec.jce.X509Principal;
import cn.com.infosec.util.Arrays;
import cn.com.infosec.util.Selector;
import cn.com.infosec.x509.X509Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;

public class AttributeCertificateHolder
implements CertSelector,
Selector {
    final Holder holder;

    AttributeCertificateHolder(ASN1Sequence seq) {
        this.holder = Holder.getInstance(seq);
    }

    public AttributeCertificateHolder(X509Principal issuerName, BigInteger serialNumber) {
        this.holder = new Holder(new IssuerSerial(new GeneralNames(new DERSequence(new GeneralName(issuerName))), new DERInteger(serialNumber)));
    }

    public AttributeCertificateHolder(X500Principal issuerName, BigInteger serialNumber) {
        this(X509Util.convertPrincipal(issuerName), serialNumber);
    }

    public AttributeCertificateHolder(X509Certificate cert) throws CertificateParsingException {
        X509Principal name;
        try {
            name = PrincipalUtil.getIssuerX509Principal(cert);
        }
        catch (Exception e) {
            throw new CertificateParsingException(e.getMessage());
        }
        this.holder = new Holder(new IssuerSerial(this.generateGeneralNames(name), new DERInteger(cert.getSerialNumber())));
    }

    public AttributeCertificateHolder(X509Principal principal) {
        this.holder = new Holder(this.generateGeneralNames(principal));
    }

    public AttributeCertificateHolder(X500Principal principal) {
        this(X509Util.convertPrincipal(principal));
    }

    public AttributeCertificateHolder(int digestedObjectType, String digestAlgorithm, String otherObjectTypeID, byte[] objectDigest) {
        this.holder = new Holder(new ObjectDigestInfo(digestedObjectType, otherObjectTypeID, new AlgorithmIdentifier(digestAlgorithm), Arrays.clone(objectDigest)));
    }

    public int getDigestedObjectType() {
        if (this.holder.getObjectDigestInfo() != null) {
            return this.holder.getObjectDigestInfo().getDigestedObjectType().getValue().intValue();
        }
        return -1;
    }

    public String getDigestAlgorithm() {
        if (this.holder.getObjectDigestInfo() != null) {
            this.holder.getObjectDigestInfo().getDigestAlgorithm().getObjectId().getId();
        }
        return null;
    }

    public byte[] getObjectDigest() {
        if (this.holder.getObjectDigestInfo() != null) {
            this.holder.getObjectDigestInfo().getObjectDigest().getBytes();
        }
        return null;
    }

    public String getOtherObjectTypeID() {
        if (this.holder.getObjectDigestInfo() != null) {
            this.holder.getObjectDigestInfo().getOtherObjectTypeID().getId();
        }
        return null;
    }

    private GeneralNames generateGeneralNames(X509Principal principal) {
        return new GeneralNames(new DERSequence(new GeneralName(principal)));
    }

    private boolean matchesDN(X509Principal subject, GeneralNames targets) {
        GeneralName[] names = targets.getNames();
        int i = 0;
        while (i != names.length) {
            GeneralName gn = names[i];
            if (gn.getTagNo() == 4) {
                try {
                    if (new X509Principal(((ASN1Encodable)gn.getName()).getEncoded()).equals(subject)) {
                        return true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return false;
    }

    private Object[] getNames(GeneralName[] names) {
        ArrayList<X500Principal> l = new ArrayList<X500Principal>(names.length);
        int i = 0;
        while (i != names.length) {
            if (names[i].getTagNo() == 4) {
                try {
                    l.add(new X500Principal(((ASN1Encodable)names[i].getName()).getEncoded()));
                }
                catch (IOException e) {
                    throw new RuntimeException("badly formed Name object");
                }
            }
            ++i;
        }
        return l.toArray(new Object[l.size()]);
    }

    private Principal[] getPrincipals(GeneralNames names) {
        Object[] p = this.getNames(names.getNames());
        ArrayList<Object> l = new ArrayList<Object>();
        int i = 0;
        while (i != p.length) {
            if (p[i] instanceof Principal) {
                l.add(p[i]);
            }
            ++i;
        }
        return l.toArray(new Principal[l.size()]);
    }

    public Principal[] getEntityNames() {
        if (this.holder.getEntityName() != null) {
            return this.getPrincipals(this.holder.getEntityName());
        }
        return null;
    }

    public Principal[] getIssuer() {
        if (this.holder.getBaseCertificateID() != null) {
            return this.getPrincipals(this.holder.getBaseCertificateID().getIssuer());
        }
        return null;
    }

    public BigInteger getSerialNumber() {
        if (this.holder.getBaseCertificateID() != null) {
            return this.holder.getBaseCertificateID().getSerial().getValue();
        }
        return null;
    }

    public Object clone() {
        return new AttributeCertificateHolder((ASN1Sequence)this.holder.toASN1Object());
    }

    public boolean match(Certificate cert) {
        block14: {
            block13: {
                if (!(cert instanceof X509Certificate)) {
                    return false;
                }
                X509Certificate x509Cert = (X509Certificate)cert;
                try {
                    if (this.holder.getBaseCertificateID() != null) {
                        return this.holder.getBaseCertificateID().getSerial().getValue().equals(x509Cert.getSerialNumber()) && this.matchesDN(PrincipalUtil.getIssuerX509Principal(x509Cert), this.holder.getBaseCertificateID().getIssuer());
                    }
                    if (this.holder.getEntityName() == null || !this.matchesDN(PrincipalUtil.getSubjectX509Principal(x509Cert), this.holder.getEntityName())) break block13;
                    return true;
                }
                catch (CertificateEncodingException e) {
                    return false;
                }
            }
            if (this.holder.getObjectDigestInfo() == null) break block14;
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance(this.getDigestAlgorithm(), "INFOSEC");
            }
            catch (Exception e) {
                return false;
            }
            switch (this.getDigestedObjectType()) {
                case 0: {
                    md.update(cert.getPublicKey().getEncoded());
                    break;
                }
                case 1: {
                    md.update(cert.getEncoded());
                }
            }
            if (!Arrays.areEqual(md.digest(), this.getObjectDigest())) {
                return false;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AttributeCertificateHolder)) {
            return false;
        }
        AttributeCertificateHolder other = (AttributeCertificateHolder)obj;
        return this.holder.equals(other.holder);
    }

    public int hashCode() {
        return this.holder.hashCode();
    }

    public boolean match(Object obj) {
        if (!(obj instanceof X509Certificate)) {
            return false;
        }
        return this.match((Certificate)obj);
    }
}

