/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.openssl;

import cn.com.infosec.crypto.PBEParametersGenerator;
import cn.com.infosec.crypto.generators.OpenSSLPBEParametersGenerator;
import cn.com.infosec.crypto.params.KeyParameter;
import java.io.IOException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

final class PEMUtilities {
    PEMUtilities() {
    }

    static byte[] crypt(boolean encrypt, String provider, byte[] bytes, char[] password, String dekAlgName, byte[] iv) throws IOException {
        SecretKey sKey;
        String alg;
        AlgorithmParameterSpec paramSpec = new IvParameterSpec(iv);
        String blockMode = "CBC";
        String padding = "PKCS5Padding";
        if (dekAlgName.endsWith("-CFB")) {
            blockMode = "CFB";
            padding = "NoPadding";
        }
        if (dekAlgName.endsWith("-ECB") || "DES-EDE".equals(dekAlgName) || "DES-EDE3".equals(dekAlgName)) {
            blockMode = "ECB";
            paramSpec = null;
        }
        if (dekAlgName.endsWith("-OFB")) {
            blockMode = "OFB";
            padding = "NoPadding";
        }
        if (dekAlgName.startsWith("DES-EDE")) {
            alg = "DESede";
            boolean des2 = !dekAlgName.startsWith("DES-EDE3");
            sKey = PEMUtilities.getKey(password, alg, 24, iv, des2);
        } else if (dekAlgName.startsWith("DES-")) {
            alg = "DES";
            sKey = PEMUtilities.getKey(password, alg, 8, iv);
        } else if (dekAlgName.startsWith("BF-")) {
            alg = "Blowfish";
            sKey = PEMUtilities.getKey(password, alg, 16, iv);
        } else if (dekAlgName.startsWith("RC2-")) {
            alg = "RC2";
            int keyBits = 128;
            if (dekAlgName.startsWith("RC2-40-")) {
                keyBits = 40;
            } else if (dekAlgName.startsWith("RC2-64-")) {
                keyBits = 64;
            }
            sKey = PEMUtilities.getKey(password, alg, keyBits / 8, iv);
            paramSpec = paramSpec == null ? new RC2ParameterSpec(keyBits) : new RC2ParameterSpec(keyBits, iv);
        } else if (dekAlgName.startsWith("AES-")) {
            int keyBits;
            alg = "AES";
            byte[] salt = iv;
            if (salt.length > 8) {
                salt = new byte[8];
                System.arraycopy(iv, 0, salt, 0, 8);
            }
            if (dekAlgName.startsWith("AES-128-")) {
                keyBits = 128;
            } else if (dekAlgName.startsWith("AES-192-")) {
                keyBits = 192;
            } else if (dekAlgName.startsWith("AES-256-")) {
                keyBits = 256;
            } else {
                throw new IOException("unknown AES encryption with private key");
            }
            sKey = PEMUtilities.getKey(password, "AES", keyBits / 8, salt);
        } else {
            throw new IOException("unknown encryption with private key");
        }
        String transformation = String.valueOf(alg) + "/" + blockMode + "/" + padding;
        try {
            int mode;
            Cipher c = Cipher.getInstance(transformation, provider);
            int n = mode = encrypt ? 1 : 2;
            if (paramSpec == null) {
                c.init(mode, sKey);
            } else {
                c.init(mode, (Key)sKey, paramSpec);
            }
            return c.doFinal(bytes);
        }
        catch (Exception e) {
            throw new IOException("exception using cipher: " + e.toString());
        }
    }

    private static SecretKey getKey(char[] password, String algorithm, int keyLength, byte[] salt) throws IOException {
        return PEMUtilities.getKey(password, algorithm, keyLength, salt, false);
    }

    private static SecretKey getKey(char[] password, String algorithm, int keyLength, byte[] salt, boolean des2) throws IOException {
        OpenSSLPBEParametersGenerator pGen = new OpenSSLPBEParametersGenerator();
        pGen.init(PBEParametersGenerator.PKCS5PasswordToBytes(password), salt);
        KeyParameter keyParam = (KeyParameter)pGen.generateDerivedParameters(keyLength * 8);
        byte[] key = keyParam.getKey();
        if (des2 && key.length >= 24) {
            System.arraycopy(key, 0, key, 16, 8);
        }
        return new SecretKeySpec(key, algorithm);
    }
}

