/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider.fastparser;

import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1StreamParser;
import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.jce.provider.fastparser.DerUtil;
import cn.com.infosec.jce.provider.fastparser.EnvelopedData;
import cn.com.infosec.jce.provider.fastparser.FX509Certificate;
import cn.com.infosec.jce.provider.fastparser.IssuerAndSerialNumber;
import cn.com.infosec.jce.provider.fastparser.Item;
import cn.com.infosec.jce.provider.fastparser.RawData;
import cn.com.infosec.jce.provider.fastparser.SignedData;
import cn.com.infosec.jce.provider.fastparser.SignerInfo;
import cn.com.infosec.util.Base64;
import java.util.ArrayList;

public class FastPkcs7 {
    private byte[] p7b;
    private Item contentOID;
    private int contentType = 0;
    private int version = 0;
    private int signVersion = 0;
    private Item contents;
    private ArrayList certs = new ArrayList();
    private ArrayList crls = new ArrayList();
    private ArrayList daset = new ArrayList();
    private ArrayList signerInfos = new ArrayList();
    private Item signCert = new Item();
    private String digestAlgorithm = null;
    private String digestEncryptionAlgorithm = null;
    private Item digest = new Item();
    private Item data = new Item();
    private Item rawData = new Item();
    private EnvelopedData ed = null;
    private byte[] encryptedContentInfo = null;
    private byte[] encryptedContentInfoAlgId = null;
    private String encryptedContentInfoAlgIdStr = null;
    private byte[] encryptedContentInfoIvParam = null;
    private ArrayList recipientInfos = new ArrayList();

    public boolean pkcs7SignedData(byte[] input) {
        Item tmpitem = new Item();
        int position = 0;
        DerUtil.computeOffset(input, tmpitem, 0, position);
        position = tmpitem.offset;
        DerUtil.computeOffset(input, tmpitem, 0, position);
        this.contentOID = new Item(tmpitem);
        this.contentType = DerUtil.getContentType(input, tmpitem.offset);
        position = tmpitem.offset + tmpitem.length;
        DerUtil.computeOffset(input, tmpitem, 0, position);
        this.contents = new Item(tmpitem);
        switch (this.contentType) {
            case 1: {
                this.data = new Item(tmpitem);
                if (this.data.length <= 0) break;
                DerUtil.computeOffset(input, this.rawData, this.data.offset, 0);
                this.rawData.offset += this.data.offset;
                break;
            }
            case 2: {
                ArrayList tmpsi;
                SignedData sd = new SignedData(input, this.contents);
                this.version = sd.getVersion();
                if (sd.getContentInfo().getContentType() == 1) {
                    Item cii = new Item(sd.getContentInfo().getContent());
                    RawData rd = new RawData(input, cii);
                    byte[] rdd = new byte[rd.getData().length];
                    System.arraycopy(rd.getData(), 0, rdd, 0, rdd.length);
                    this.rawData = new Item(rd.getRawData());
                }
                this.certs.addAll(sd.getCertificates());
                this.crls.addAll(sd.getCrls());
                if (this.daset.addAll(sd.getDigestAlgorithms())) {
                    if (DerUtil.debug) {
                        int i = 0;
                        while (i < this.daset.size()) {
                            DerUtil.printItemAndTag(input, (Item)this.daset.get(i));
                            System.out.println("Digest Algorithms: " + DerUtil.toDERObjectIdentifier(input, ((Item)this.daset.get((int)i)).offset, ((Item)this.daset.get((int)i)).length));
                            ++i;
                        }
                    }
                    this.digestAlgorithm = DerUtil.toDERObjectIdentifier(input, ((Item)this.daset.get((int)0)).offset, ((Item)this.daset.get((int)0)).length);
                }
                if (!(tmpsi = new ArrayList()).addAll(sd.getSignerInfos())) break;
                int i = 0;
                while (i < tmpsi.size()) {
                    Item it = (Item)tmpsi.get(i);
                    SignerInfo si = new SignerInfo(input, it.offset - it.tagsize, it.length + it.tagsize);
                    this.signerInfos.add(si);
                    if (DerUtil.debug) {
                        this.printSignerInfo(input, si);
                    }
                    IssuerAndSerialNumber iasn = new IssuerAndSerialNumber(input, si.getIssuerAndSerialNumber());
                    Item issuerItem = new Item(iasn.getIssuer());
                    if (DerUtil.debug) {
                        System.out.println("IssuerItem:");
                        DerUtil.printItem(input, issuerItem);
                    }
                    int index = 0;
                    while (index < this.certs.size()) {
                        Item itCert = new Item();
                        itCert.tagsize = ((Item)this.certs.get((int)index)).tagsize;
                        itCert.length = ((Item)this.certs.get((int)index)).length + itCert.tagsize;
                        itCert.offset = ((Item)this.certs.get((int)index)).offset - itCert.tagsize;
                        FX509Certificate fx = new FX509Certificate(input, itCert);
                        byte[] sn = new byte[fx.getSerialNumber().length];
                        System.arraycopy(input, fx.getSerialNumber().offset, sn, 0, sn.length);
                        if ((DerUtil.isEqual(input, issuerItem.offset - issuerItem.tagsize, input, fx.getIssuer().offset, issuerItem.length) || this.compareDN(input, issuerItem.offset - issuerItem.tagsize, issuerItem.length + issuerItem.tagsize, input, fx.getIssuer().offset, fx.getIssuer().length + fx.getIssuer().tagsize)) && DerUtil.isNumberEqual(sn, iasn.getSerialNumber().getSn())) {
                            this.signCert = new Item((Item)this.certs.get(index));
                            this.digestAlgorithm = DerUtil.toDERObjectIdentifier(input, si.getDigestAlgorithm().offset, si.getDigestAlgorithm().length);
                            this.digestEncryptionAlgorithm = DerUtil.toDERObjectIdentifier(input, si.getDigestEncryptionAlgorithm().offset, si.getDigestEncryptionAlgorithm().length);
                            this.digest = new Item(si.getEncryptedDigest());
                            this.signVersion = si.getSignerInfoVersion();
                            break;
                        }
                        ++index;
                    }
                    ++i;
                }
                tmpsi.clear();
                break;
            }
            case 3: {
                this.ed = new EnvelopedData(input, this.contents);
                if (this.ed.getEncryptedContentInfoObject() != null) {
                    tmpitem = this.ed.getEncryptedContentInfoObject().getContentEncryptionAlgorithm();
                    if (tmpitem.length > 0) {
                        this.encryptedContentInfoAlgIdStr = DerUtil.toDERObjectIdentifier(input, tmpitem.offset, tmpitem.length);
                    }
                    tmpitem = this.ed.getEncryptedContentInfoObject().getIvParameter();
                    if (tmpitem.length > 0 && (input[tmpitem.offset] & 0xFF) != 5) {
                        this.encryptedContentInfoIvParam = new byte[tmpitem.length];
                        System.arraycopy(input, tmpitem.offset, this.encryptedContentInfoIvParam, 0, tmpitem.length);
                    }
                    tmpitem = this.ed.getEncryptedContentInfoObject().getEncryptedContent();
                    if (tmpitem.length > 0) {
                        this.encryptedContentInfo = new byte[tmpitem.length];
                        System.arraycopy(input, tmpitem.offset, this.encryptedContentInfo, 0, tmpitem.length);
                    }
                }
                this.recipientInfos = this.ed.getVRecipientInfo();
                if (!DerUtil.debug) break;
                System.out.println("Version is " + this.ed.getVer());
                DerUtil.printItem(input, this.ed.getEncryptedContentInfo());
            }
        }
        return true;
    }

    private boolean compareDN(byte[] bs1, int offset1, int length1, byte[] bs2, int offset2, int length2) {
        byte[] dnbs1 = new byte[length1];
        System.arraycopy(bs1, offset1, dnbs1, 0, length1);
        byte[] dnbs2 = new byte[length2];
        System.arraycopy(bs2, offset2, dnbs2, 0, length2);
        try {
            X509Name dn1 = new X509Name((ASN1Sequence)new ASN1StreamParser(dnbs1).readObject().getDERObject());
            X509Name dn2 = new X509Name((ASN1Sequence)new ASN1StreamParser(dnbs2).readObject().getDERObject());
            return dn1.equals(dn2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public final ArrayList getDigestAlgorithms() {
        return this.daset;
    }

    public final ArrayList getCerts() {
        return this.certs;
    }

    public final ArrayList getCrls() {
        return this.crls;
    }

    public final Item getSignCert() {
        return this.signCert;
    }

    public final String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public final String getDigestEncryptionAlgorithm() {
        return this.digestEncryptionAlgorithm;
    }

    public final Item getDigest() {
        return this.digest;
    }

    public final Item getRawData() {
        return this.rawData;
    }

    public byte[] getPkcs7(byte[] p7) {
        if (p7[0] == 48) {
            return p7;
        }
        try {
            return Base64.decode(p7);
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public void printSignerInfo(byte[] input, SignerInfo si) {
        System.out.println("getAaSequence:");
        DerUtil.printItem(input, si.getAaSequence());
        System.out.println("getAuthenticatedAttributes:");
        DerUtil.printItem(input, si.getAuthenticatedAttributes());
        System.out.println("getDigestAlgorithm: " + DerUtil.toDERObjectIdentifier(input, si.getDigestAlgorithm().offset, si.getDigestAlgorithm().length));
        DerUtil.printItem(input, si.getDigestAlgorithm());
        System.out.println("getDigestEncryptionAlgorithm: " + DerUtil.toDERObjectIdentifier(input, si.getDigestEncryptionAlgorithm().offset, si.getDigestEncryptionAlgorithm().length));
        DerUtil.printItem(input, si.getDigestEncryptionAlgorithm());
        System.out.println("getIssuerAndSerialNumber:");
        DerUtil.printItem(input, si.getIssuerAndSerialNumber());
        IssuerAndSerialNumber iasn = new IssuerAndSerialNumber(input, si.getIssuerAndSerialNumber());
        System.out.println("SN=" + iasn.getSerialNumber().getSerialNumber());
        System.out.println("getUnauthenticatedAttributes:");
        DerUtil.printItem(input, si.getUnauthenticatedAttributes());
    }

    public final EnvelopedData getEnvelopedData() {
        return this.ed;
    }

    public final byte[] getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public final String getEncryptedContentInfoAlgIdStr() {
        return this.encryptedContentInfoAlgIdStr;
    }

    public final byte[] getEncryptedContentInfoIvParam() {
        return this.encryptedContentInfoIvParam;
    }

    public final ArrayList getRecipientInfos() {
        return this.recipientInfos;
    }

    public final int getContentType() {
        return this.contentType;
    }

    public final int getVersion() {
        return this.version;
    }

    public final int getSignInfoVersion() {
        return this.signVersion;
    }

    public Item getContentOID() {
        return this.contentOID;
    }

    public static void main(String[] args) throws Exception {
        String p7Str = "MIICaAYKKoEcz1UGAQQCAqCCAlgwggJUAgEBMQ4wDAYIKoEcz1UBgxEFADAMBgoqgRzPVQYBBAIBoIIBkDCCAYwwggEwoAMCAQICBRAAABFWMAwGCCqBHM9VAYN1BQAwJzELMAkGA1UEBhMCQ04xGDAWBgNVBAoMD0NGQ0Egc20yIFJDQTExMTAeFw0xMzAyMjYwMjU5MjFaFw0xNDAyMjEwMjU5MjFaMB8xCzAJBgNVBAYTAkNOMRAwDgYDVQQDDAdzbTJ0ZXN0MFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAE7VVu9jkN1i0oUDtp0ocl8pXKF0eHXtKewa8wzmR9Ym98j67PDOhxq8YUr9VuRw+CDaJmmXZuHuf+VYjSx3qIwqNPME0wHwYDVR0jBBgwFoAUAJAK6++jihENFsJYJe0OJ5DtGCcwCwYDVR0PBAQDAgbAMB0GA1UdDgQWBBRbEMk1WzZ9V7LCM/Ae/LJEvkDMizAMBggqgRzPVQGDdQUAA0gAMEUCIHqrOB1qmaYKJPUz6j5dyxcHlyjlyqM49ixHiJQ/m/TXAiEA1+o0P25BzTa7rygPOVFXU7CKspXQHW8tyQyc/+2rsoAxgZwwgZkCAQEwMDAnMQswCQYDVQQGEwJDTjEYMBYGA1UECgwPQ0ZDQSBzbTIgUkNBMTExAgUQAAARVjAMBggqgRzPVQGDEQUAMAwGCCqBHM9VAYN1BQAwRgIhAJdtI9zvURu8XmIU9mmD6vguOg6H27d+iqwy1xafJ1GuAiEA3aeMC6gdLX1jsZrCtb81cjWSVNf+oYqlCQIh7hVx+Dg=";
        FastPkcs7 fp7 = new FastPkcs7();
        DerUtil.debug = true;
        fp7.pkcs7SignedData(Base64.decode(p7Str));
        System.out.println("certs size=" + fp7.certs.size());
        System.out.println("sign cert offset=" + fp7.signCert.offset);
    }
}

