/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider.fastparser;

import cn.com.infosec.jce.provider.fastparser.DerUtil;
import cn.com.infosec.jce.provider.fastparser.Item;

public class FX509Certificate {
    private Item tbsCertificate = new Item();
    private Item signatureAlgorithm = new Item();
    private Item signatureValue = new Item();
    private Item version = new Item();
    private Item serialNumber = new Item();
    private Item signature = new Item();
    private Item issuer = new Item();
    private Item validity = new Item();
    private Item subject = new Item();
    private Item subjectPublicKeyInfo = new Item();
    private Item issuerUniqueID;
    private Item subjectUniqueID;
    private Item extensions = new Item();
    private byte[] input = null;

    public byte[] getItemData(Item item) {
        if (item == null) {
            return new byte[0];
        }
        byte[] bs = new byte[item.length];
        System.arraycopy(this.input, item.offset, bs, 0, item.length);
        return bs;
    }

    public byte[] getItemDataAndTag(Item item) {
        if (item == null) {
            return new byte[0];
        }
        byte[] bs = new byte[item.length + item.tagsize];
        System.arraycopy(this.input, item.offset - item.tagsize, bs, 0, item.length + item.tagsize);
        return bs;
    }

    public FX509Certificate() {
    }

    public FX509Certificate(byte[] input, Item it) {
        this.parse(input, it.offset, it.length);
    }

    public void parse(byte[] input, int offset, int length) {
        this.input = input;
        int position = 0;
        Item tmpitem = new Item();
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset;
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.tbsCertificate = new Item(tmpitem);
        if (DerUtil.debug) {
            System.out.println("###############TBSCertificate @ FX509Certificate:");
            DerUtil.printItem(input, this.tbsCertificate);
        }
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.signatureAlgorithm = new Item(tmpitem);
        if (DerUtil.debug) {
            System.out.println("Certificate signatureAlgorithm @ (" + this.signatureAlgorithm.offset + "," + this.signatureAlgorithm.length);
            DerUtil.printItem(input, this.signatureAlgorithm);
        }
        this.signatureAlgorithm.offset += offset;
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.signatureValue = new Item(tmpitem);
        if (DerUtil.debug) {
            System.out.println("Certificate signatureValue @ (" + this.signatureValue.offset + "," + this.signatureValue.length);
            DerUtil.printItem(input, this.signatureValue);
        }
        if ((input[(position = this.tbsCertificate.offset - offset) + offset] & 0xA0) == 160) {
            DerUtil.computeOffset(input, tmpitem, offset, position);
            position = tmpitem.offset + tmpitem.length;
            tmpitem.offset += offset;
            this.version = new Item(tmpitem);
            if (DerUtil.debug) {
                System.out.println("version");
                DerUtil.printItem(input, this.version);
            }
        }
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.serialNumber = new Item(tmpitem);
        if (DerUtil.debug) {
            System.out.println("serialNumber @ FX509Certificate:");
            DerUtil.printItem(input, this.serialNumber);
        }
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.signature = new Item(tmpitem);
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.issuer = new Item(tmpitem);
        this.issuer.offset -= this.issuer.tagsize;
        this.issuer.length += this.issuer.tagsize;
        if (DerUtil.debug) {
            System.out.println("issuer @ FX509Certificate:");
            DerUtil.printItem(input, this.issuer);
        }
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.validity = new Item(tmpitem);
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.subject = new Item(tmpitem);
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.subjectPublicKeyInfo = new Item(tmpitem);
        if (position + offset < length && (input[position + offset] & 0xFF) == 161) {
            DerUtil.computeOffset(input, tmpitem, offset, position);
            position = tmpitem.offset + tmpitem.length;
            tmpitem.offset += offset;
            this.issuerUniqueID = new Item(tmpitem);
        }
        if (position + offset < length && (input[position + offset] & 0xFF) == 162) {
            DerUtil.computeOffset(input, tmpitem, offset, position);
            position = tmpitem.offset + tmpitem.length;
            tmpitem.offset += offset;
            this.subjectUniqueID = new Item(tmpitem);
        }
        if (position + offset < input.length && (input[position + offset] & 0xFF) == 163) {
            DerUtil.computeOffset(input, tmpitem, offset, position);
            position = tmpitem.offset + tmpitem.length;
            tmpitem.offset += offset;
            this.extensions = new Item(tmpitem);
        }
    }

    public final boolean isRoot(byte[] input, int offset, int length, byte[] cert, int certoffset, int certlength) {
        FX509Certificate ix = new FX509Certificate();
        FX509Certificate rx = new FX509Certificate();
        ix.parse(input, offset, length);
        rx.parse(cert, certoffset, length);
        return DerUtil.isEqual(input, ix.issuer.offset, cert, rx.subject.offset, ix.issuer.length);
    }

    public final boolean isEqual(byte[] input, int offset, int length, byte[] cert, int certoffset, int certlength) {
        FX509Certificate ix = new FX509Certificate();
        FX509Certificate rx = new FX509Certificate();
        ix.parse(input, offset, length);
        rx.parse(cert, certoffset, length);
        return DerUtil.isEqual(input, ix.subject.offset, cert, rx.subject.offset, ix.subject.length) && DerUtil.isEqual(input, ix.issuer.offset, cert, rx.issuer.offset, ix.issuer.length);
    }

    public final Item getTbsCertificate() {
        return this.tbsCertificate;
    }

    public final Item getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public final Item getSignatureValue() {
        return this.signatureValue;
    }

    public final Item getVersion() {
        return this.version;
    }

    public final Item getSerialNumber() {
        return this.serialNumber;
    }

    public final Item getSignature() {
        return this.signature;
    }

    public final Item getIssuer() {
        return this.issuer;
    }

    public final Item getValidity() {
        return this.validity;
    }

    public final Item getSubject() {
        return this.subject;
    }

    public final Item getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public final Item getIssuerUniqueID() {
        return this.issuerUniqueID;
    }

    public final Item getSubjectUniqueID() {
        return this.subjectUniqueID;
    }

    public final Item getExtensions() {
        return this.extensions;
    }
}

