/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider;

import cn.com.infosec.asn1.ASN1Object;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.cryptopro.CryptoProObjectIdentifiers;
import cn.com.infosec.asn1.oiw.OIWObjectIdentifiers;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.pkcs.PrivateKeyInfo;
import cn.com.infosec.asn1.pkcs.RSAPrivateKeyStructure;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.asn1.x9.X9ObjectIdentifiers;
import cn.com.infosec.crypto.RuntimeCryptoException;
import cn.com.infosec.jce.interfaces.ElGamalPrivateKey;
import cn.com.infosec.jce.interfaces.ElGamalPublicKey;
import cn.com.infosec.jce.provider.JCEDHPrivateKey;
import cn.com.infosec.jce.provider.JCEDHPublicKey;
import cn.com.infosec.jce.provider.JCEECPrivateKey;
import cn.com.infosec.jce.provider.JCEECPublicKey;
import cn.com.infosec.jce.provider.JCEElGamalPrivateKey;
import cn.com.infosec.jce.provider.JCEElGamalPublicKey;
import cn.com.infosec.jce.provider.JCERSAPrivateCrtKey;
import cn.com.infosec.jce.provider.JCERSAPrivateKey;
import cn.com.infosec.jce.provider.JCERSAPublicKey;
import cn.com.infosec.jce.provider.JCESM2PrivateKey;
import cn.com.infosec.jce.provider.JCESM2PublicKey;
import cn.com.infosec.jce.provider.JDKDSAPrivateKey;
import cn.com.infosec.jce.provider.JDKDSAPublicKey;
import cn.com.infosec.jce.provider.JDKGOST3410PrivateKey;
import cn.com.infosec.jce.provider.JDKGOST3410PublicKey;
import cn.com.infosec.jce.provider.RSAUtil;
import cn.com.infosec.jce.spec.ECPrivateKeySpec;
import cn.com.infosec.jce.spec.ECPublicKeySpec;
import cn.com.infosec.jce.spec.ElGamalPrivateKeySpec;
import cn.com.infosec.jce.spec.ElGamalPublicKeySpec;
import cn.com.infosec.jce.spec.GOST3410PrivateKeySpec;
import cn.com.infosec.jce.spec.GOST3410PublicKeySpec;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public abstract class JDKKeyFactory
extends KeyFactorySpi {
    protected boolean elGamalFactory = false;
    public static final byte[] ALG_PARAMETER_SM2_INFOSEC = new byte[]{6, 10, 42, -127, 28, -127, 69, -50, 61, 3, 1, 7};
    public static final byte[] ALG_PARAMETER_SM2_INFOSEC_NEW = new byte[]{6, 8, 42, -127, 28, -49, 85, 1, -126, 45};
    public static final byte[] ALG_PARAMETER_SM2_DETACH = new byte[]{2, 1, 7};

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                return JDKKeyFactory.createPrivateKeyFromDERStream(((PKCS8EncodedKeySpec)keySpec).getEncoded());
            }
            catch (Exception e) {
                throw new InvalidKeySpecException(e.toString());
            }
        }
        throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                return JDKKeyFactory.createPublicKeyFromDERStream(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            catch (Exception e) {
                throw new InvalidKeySpecException(e.toString());
            }
        }
        throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
    }

    protected KeySpec engineGetKeySpec(Key key, Class spec) throws InvalidKeySpecException {
        if (spec.isAssignableFrom(PKCS8EncodedKeySpec.class) && key.getFormat().equals("PKCS#8")) {
            return new PKCS8EncodedKeySpec(key.getEncoded());
        }
        if (spec.isAssignableFrom(X509EncodedKeySpec.class) && key.getFormat().equals("X.509")) {
            return new X509EncodedKeySpec(key.getEncoded());
        }
        if (spec.isAssignableFrom(RSAPublicKeySpec.class) && key instanceof RSAPublicKey) {
            RSAPublicKey k = (RSAPublicKey)key;
            return new RSAPublicKeySpec(k.getModulus(), k.getPublicExponent());
        }
        if (spec.isAssignableFrom(RSAPrivateKeySpec.class) && key instanceof RSAPrivateKey) {
            RSAPrivateKey k = (RSAPrivateKey)key;
            return new RSAPrivateKeySpec(k.getModulus(), k.getPrivateExponent());
        }
        if (spec.isAssignableFrom(RSAPrivateCrtKeySpec.class) && key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey k = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeySpec(k.getModulus(), k.getPublicExponent(), k.getPrivateExponent(), k.getPrimeP(), k.getPrimeQ(), k.getPrimeExponentP(), k.getPrimeExponentQ(), k.getCrtCoefficient());
        }
        if (spec.isAssignableFrom(DHPrivateKeySpec.class) && key instanceof DHPrivateKey) {
            DHPrivateKey k = (DHPrivateKey)key;
            return new DHPrivateKeySpec(k.getX(), k.getParams().getP(), k.getParams().getG());
        }
        if (spec.isAssignableFrom(DHPublicKeySpec.class) && key instanceof DHPublicKey) {
            DHPublicKey k = (DHPublicKey)key;
            return new DHPublicKeySpec(k.getY(), k.getParams().getP(), k.getParams().getG());
        }
        if (spec.isAssignableFrom(java.security.spec.ECPublicKeySpec.class) && key instanceof ECPublicKey) {
            ECPublicKey k = (ECPublicKey)key;
            return new java.security.spec.ECPublicKeySpec(k.getW(), k.getParams());
        }
        if (spec.isAssignableFrom(java.security.spec.ECPrivateKeySpec.class) && key instanceof ECPrivateKey) {
            ECPrivateKey k = (ECPrivateKey)key;
            return new java.security.spec.ECPrivateKeySpec(k.getS(), k.getParams());
        }
        throw new RuntimeException("not implemented yet " + key + " " + spec);
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof RSAPublicKey) {
            return new JCERSAPublicKey((RSAPublicKey)key);
        }
        if (key instanceof RSAPrivateCrtKey) {
            return new JCERSAPrivateCrtKey((RSAPrivateCrtKey)key);
        }
        if (key instanceof RSAPrivateKey) {
            return new JCERSAPrivateKey((RSAPrivateKey)key);
        }
        if (key instanceof DHPublicKey) {
            if (this.elGamalFactory) {
                return new JCEElGamalPublicKey((DHPublicKey)key);
            }
            return new JCEDHPublicKey((DHPublicKey)key);
        }
        if (key instanceof DHPrivateKey) {
            if (this.elGamalFactory) {
                return new JCEElGamalPrivateKey((DHPrivateKey)key);
            }
            return new JCEDHPrivateKey((DHPrivateKey)key);
        }
        if (key instanceof DSAPublicKey) {
            return new JDKDSAPublicKey((DSAPublicKey)key);
        }
        if (key instanceof DSAPrivateKey) {
            return new JDKDSAPrivateKey((DSAPrivateKey)key);
        }
        if (key instanceof ElGamalPublicKey) {
            return new JCEElGamalPublicKey((ElGamalPublicKey)key);
        }
        if (key instanceof ElGamalPrivateKey) {
            return new JCEElGamalPrivateKey((ElGamalPrivateKey)key);
        }
        if (key instanceof ECPublicKey) {
            return new JCEECPublicKey((ECPublicKey)key);
        }
        if (key instanceof ECPrivateKey) {
            return new JCEECPrivateKey((ECPrivateKey)key);
        }
        throw new InvalidKeyException("key type unknown");
    }

    public static PublicKey createPublicKeyFromDERStream(byte[] in) throws IOException {
        return JDKKeyFactory.createPublicKeyFromPublicKeyInfo(new SubjectPublicKeyInfo((ASN1Sequence)ASN1Object.fromByteArray(in)));
    }

    public static PublicKey createPublicKeyFromPublicKeyInfo(SubjectPublicKeyInfo info) {
        DERObjectIdentifier algOid = info.getAlgorithmId().getObjectId();
        if (RSAUtil.isRsaOid(algOid)) {
            return new JCERSAPublicKey(info);
        }
        if (algOid.equals(PKCSObjectIdentifiers.dhKeyAgreement)) {
            return new JCEDHPublicKey(info);
        }
        if (algOid.equals(X9ObjectIdentifiers.dhpublicnumber)) {
            return new JCEDHPublicKey(info);
        }
        if (algOid.equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            return new JCEElGamalPublicKey(info);
        }
        if (algOid.equals(X9ObjectIdentifiers.id_dsa)) {
            return new JDKDSAPublicKey(info);
        }
        if (algOid.equals(OIWObjectIdentifiers.dsaWithSHA1)) {
            return new JDKDSAPublicKey(info);
        }
        if (algOid.equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            try {
                byte[] algCoded = info.getAlgorithmId().getParameters().getDERObject().getDEREncoded();
                if (Arrays.equals(algCoded, ALG_PARAMETER_SM2_INFOSEC_NEW) || Arrays.equals(algCoded, ALG_PARAMETER_SM2_INFOSEC) || Arrays.equals(ALG_PARAMETER_SM2_DETACH, algCoded)) {
                    return new JCESM2PublicKey(info.getEncoded());
                }
                return new JCEECPublicKey(info);
            }
            catch (Exception e) {
                throw new RuntimeCryptoException("Decode ecc public failed");
            }
        }
        if (algOid.equals(CryptoProObjectIdentifiers.gostR3410_94)) {
            return new JDKGOST3410PublicKey(info);
        }
        if (algOid.equals(CryptoProObjectIdentifiers.gostR3410_2001)) {
            return new JCEECPublicKey(info);
        }
        throw new RuntimeException("algorithm identifier " + algOid + " in key not recognised");
    }

    static PrivateKey createPrivateKeyFromDERStream(byte[] in) throws IOException {
        return JDKKeyFactory.createPrivateKeyFromPrivateKeyInfo(new PrivateKeyInfo((ASN1Sequence)ASN1Object.fromByteArray(in)));
    }

    static PrivateKey createPrivateKeyFromPrivateKeyInfo(PrivateKeyInfo info) {
        DERObjectIdentifier algOid = info.getAlgorithmId().getObjectId();
        if (RSAUtil.isRsaOid(algOid)) {
            return new JCERSAPrivateCrtKey(info);
        }
        if (algOid.equals(PKCSObjectIdentifiers.dhKeyAgreement)) {
            return new JCEDHPrivateKey(info);
        }
        if (algOid.equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            return new JCEElGamalPrivateKey(info);
        }
        if (algOid.equals(X9ObjectIdentifiers.id_dsa)) {
            return new JDKDSAPrivateKey(info);
        }
        if (algOid.equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            try {
                byte[] algCoded = info.getAlgorithmId().getParameters().getDERObject().getDEREncoded();
                if (Arrays.equals(algCoded, ALG_PARAMETER_SM2_INFOSEC_NEW) || Arrays.equals(algCoded, ALG_PARAMETER_SM2_INFOSEC) || Arrays.equals(ALG_PARAMETER_SM2_DETACH, algCoded)) {
                    return new JCESM2PrivateKey(info.getEncoded());
                }
                return new JCEECPrivateKey(info);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeCryptoException("Decode ecc public failed");
            }
        }
        if (algOid.equals(CryptoProObjectIdentifiers.gostR3410_94)) {
            return new JDKGOST3410PrivateKey(info);
        }
        if (algOid.equals(CryptoProObjectIdentifiers.gostR3410_2001)) {
            return new JCEECPrivateKey(info);
        }
        throw new RuntimeException("algorithm identifier " + algOid + " in key not recognised");
    }

    public static class DH
    extends JDKKeyFactory {
        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof DHPrivateKeySpec) {
                return new JCEDHPrivateKey((DHPrivateKeySpec)keySpec);
            }
            return super.engineGeneratePrivate(keySpec);
        }

        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof DHPublicKeySpec) {
                return new JCEDHPublicKey((DHPublicKeySpec)keySpec);
            }
            return super.engineGeneratePublic(keySpec);
        }
    }

    public static class DSA
    extends JDKKeyFactory {
        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof DSAPrivateKeySpec) {
                return new JDKDSAPrivateKey((DSAPrivateKeySpec)keySpec);
            }
            return super.engineGeneratePrivate(keySpec);
        }

        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof DSAPublicKeySpec) {
                return new JDKDSAPublicKey((DSAPublicKeySpec)keySpec);
            }
            return super.engineGeneratePublic(keySpec);
        }
    }

    public static class EC
    extends JDKKeyFactory {
        String algorithm;

        public EC() {
            this("EC");
        }

        public EC(String algorithm) {
            this.algorithm = algorithm;
        }

        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                try {
                    JCEECPrivateKey key = (JCEECPrivateKey)JDKKeyFactory.createPrivateKeyFromDERStream(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                    return new JCEECPrivateKey(this.algorithm, key);
                }
                catch (Exception e) {
                    throw new InvalidKeySpecException(e.toString());
                }
            }
            if (keySpec instanceof ECPrivateKeySpec) {
                return new JCEECPrivateKey(this.algorithm, (ECPrivateKeySpec)keySpec);
            }
            if (keySpec instanceof java.security.spec.ECPrivateKeySpec) {
                return new JCEECPrivateKey(this.algorithm, (java.security.spec.ECPrivateKeySpec)keySpec);
            }
            throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
        }

        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof X509EncodedKeySpec) {
                try {
                    PublicKey pubk = JDKKeyFactory.createPublicKeyFromDERStream(((X509EncodedKeySpec)keySpec).getEncoded());
                    if (pubk instanceof JCEECPublicKey) {
                        JCEECPublicKey key = (JCEECPublicKey)pubk;
                        return new JCEECPublicKey(this.algorithm, key);
                    }
                    return pubk;
                }
                catch (Exception e) {
                    throw new InvalidKeySpecException(e.toString());
                }
            }
            if (keySpec instanceof ECPublicKeySpec) {
                return new JCEECPublicKey(this.algorithm, (ECPublicKeySpec)keySpec);
            }
            if (keySpec instanceof java.security.spec.ECPublicKeySpec) {
                return new JCEECPublicKey(this.algorithm, (java.security.spec.ECPublicKeySpec)keySpec);
            }
            throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
        }
    }

    public static class ECDH
    extends EC {
        public ECDH() {
            super("ECDH");
        }
    }

    public static class ECDHC
    extends EC {
        public ECDHC() {
            super("ECDHC");
        }
    }

    public static class ECDSA
    extends EC {
        public ECDSA() {
            super("ECDSA");
        }
    }

    public static class ECGOST3410
    extends EC {
        public ECGOST3410() {
            super("ECGOST3410");
        }
    }

    public static class ElGamal
    extends JDKKeyFactory {
        public ElGamal() {
            this.elGamalFactory = true;
        }

        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof ElGamalPrivateKeySpec) {
                return new JCEElGamalPrivateKey((ElGamalPrivateKeySpec)keySpec);
            }
            if (keySpec instanceof DHPrivateKeySpec) {
                return new JCEElGamalPrivateKey((DHPrivateKeySpec)keySpec);
            }
            return super.engineGeneratePrivate(keySpec);
        }

        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof ElGamalPublicKeySpec) {
                return new JCEElGamalPublicKey((ElGamalPublicKeySpec)keySpec);
            }
            if (keySpec instanceof DHPublicKeySpec) {
                return new JCEElGamalPublicKey((DHPublicKeySpec)keySpec);
            }
            return super.engineGeneratePublic(keySpec);
        }
    }

    public static class GOST3410
    extends JDKKeyFactory {
        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof GOST3410PrivateKeySpec) {
                return new JDKGOST3410PrivateKey((GOST3410PrivateKeySpec)keySpec);
            }
            return super.engineGeneratePrivate(keySpec);
        }

        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof GOST3410PublicKeySpec) {
                return new JDKGOST3410PublicKey((GOST3410PublicKeySpec)keySpec);
            }
            return super.engineGeneratePublic(keySpec);
        }
    }

    public static class RSA
    extends JDKKeyFactory {
        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                try {
                    return JDKKeyFactory.createPrivateKeyFromDERStream(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                }
                catch (Exception e) {
                    try {
                        return new JCERSAPrivateCrtKey(new RSAPrivateKeyStructure((ASN1Sequence)ASN1Object.fromByteArray(((PKCS8EncodedKeySpec)keySpec).getEncoded())));
                    }
                    catch (Exception ex) {
                        throw new InvalidKeySpecException(ex.toString());
                    }
                }
            }
            if (keySpec instanceof RSAPrivateCrtKeySpec) {
                return new JCERSAPrivateCrtKey((RSAPrivateCrtKeySpec)keySpec);
            }
            if (keySpec instanceof RSAPrivateKeySpec) {
                return new JCERSAPrivateKey((RSAPrivateKeySpec)keySpec);
            }
            throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
        }

        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof RSAPublicKeySpec) {
                return new JCERSAPublicKey((RSAPublicKeySpec)keySpec);
            }
            return super.engineGeneratePublic(keySpec);
        }
    }

    public static class X509
    extends JDKKeyFactory {
    }
}

