/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.oscca;

import cn.com.infosec.jce.oscca.JPECPoint;
import cn.com.infosec.jce.oscca.SM2Constants;
import cn.com.infosec.jce.oscca.SM3;
import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.math.ec.ECCurve;
import cn.com.infosec.math.ec.ECPoint;
import cn.com.infosec.util.BigIntegers;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.security.Security;

public class SM2 {
    static final int SM2_SIZE = 32;
    static final BigInteger gmp = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
    static final BigInteger gma = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
    static final BigInteger gmb = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
    static final ECCurve gmec256 = new ECCurve.Fp(gmp, gma, gmb);
    static final BigInteger gmgx = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    static final BigInteger gmgy = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    static final ECPoint gmg = gmec256.createPoint(gmgx, gmgy, false);
    static final BigInteger gmn = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
    public static final byte[] defaultIdAndLength;
    private static final byte[] sm2abgxgy;
    private static final SecureRandom random;

    static {
        byte[] byArray = new byte[18];
        byArray[1] = -128;
        byArray[2] = 49;
        byArray[3] = 50;
        byArray[4] = 51;
        byArray[5] = 52;
        byArray[6] = 53;
        byArray[7] = 54;
        byArray[8] = 55;
        byArray[9] = 56;
        byArray[10] = 49;
        byArray[11] = 50;
        byArray[12] = 51;
        byArray[13] = 52;
        byArray[14] = 53;
        byArray[15] = 54;
        byArray[16] = 55;
        byArray[17] = 56;
        defaultIdAndLength = byArray;
        byte[] byArray2 = new byte[128];
        byArray2[0] = -1;
        byArray2[1] = -1;
        byArray2[2] = -1;
        byArray2[3] = -2;
        byArray2[4] = -1;
        byArray2[5] = -1;
        byArray2[6] = -1;
        byArray2[7] = -1;
        byArray2[8] = -1;
        byArray2[9] = -1;
        byArray2[10] = -1;
        byArray2[11] = -1;
        byArray2[12] = -1;
        byArray2[13] = -1;
        byArray2[14] = -1;
        byArray2[15] = -1;
        byArray2[16] = -1;
        byArray2[17] = -1;
        byArray2[18] = -1;
        byArray2[19] = -1;
        byArray2[24] = -1;
        byArray2[25] = -1;
        byArray2[26] = -1;
        byArray2[27] = -1;
        byArray2[28] = -1;
        byArray2[29] = -1;
        byArray2[30] = -1;
        byArray2[31] = -4;
        byArray2[32] = 40;
        byArray2[33] = -23;
        byArray2[34] = -6;
        byArray2[35] = -98;
        byArray2[36] = -99;
        byArray2[37] = -97;
        byArray2[38] = 94;
        byArray2[39] = 52;
        byArray2[40] = 77;
        byArray2[41] = 90;
        byArray2[42] = -98;
        byArray2[43] = 75;
        byArray2[44] = -49;
        byArray2[45] = 101;
        byArray2[46] = 9;
        byArray2[47] = -89;
        byArray2[48] = -13;
        byArray2[49] = -105;
        byArray2[50] = -119;
        byArray2[51] = -11;
        byArray2[52] = 21;
        byArray2[53] = -85;
        byArray2[54] = -113;
        byArray2[55] = -110;
        byArray2[56] = -35;
        byArray2[57] = -68;
        byArray2[58] = -67;
        byArray2[59] = 65;
        byArray2[60] = 77;
        byArray2[61] = -108;
        byArray2[62] = 14;
        byArray2[63] = -109;
        byArray2[64] = 50;
        byArray2[65] = -60;
        byArray2[66] = -82;
        byArray2[67] = 44;
        byArray2[68] = 31;
        byArray2[69] = 25;
        byArray2[70] = -127;
        byArray2[71] = 25;
        byArray2[72] = 95;
        byArray2[73] = -103;
        byArray2[74] = 4;
        byArray2[75] = 70;
        byArray2[76] = 106;
        byArray2[77] = 57;
        byArray2[78] = -55;
        byArray2[79] = -108;
        byArray2[80] = -113;
        byArray2[81] = -29;
        byArray2[82] = 11;
        byArray2[83] = -65;
        byArray2[84] = -14;
        byArray2[85] = 102;
        byArray2[86] = 11;
        byArray2[87] = -31;
        byArray2[88] = 113;
        byArray2[89] = 90;
        byArray2[90] = 69;
        byArray2[91] = -119;
        byArray2[92] = 51;
        byArray2[93] = 76;
        byArray2[94] = 116;
        byArray2[95] = -57;
        byArray2[96] = -68;
        byArray2[97] = 55;
        byArray2[98] = 54;
        byArray2[99] = -94;
        byArray2[100] = -12;
        byArray2[101] = -10;
        byArray2[102] = 119;
        byArray2[103] = -100;
        byArray2[104] = 89;
        byArray2[105] = -67;
        byArray2[106] = -50;
        byArray2[107] = -29;
        byArray2[108] = 107;
        byArray2[109] = 105;
        byArray2[110] = 33;
        byArray2[111] = 83;
        byArray2[112] = -48;
        byArray2[113] = -87;
        byArray2[114] = -121;
        byArray2[115] = 124;
        byArray2[116] = -58;
        byArray2[117] = 42;
        byArray2[118] = 71;
        byArray2[119] = 64;
        byArray2[120] = 2;
        byArray2[121] = -33;
        byArray2[122] = 50;
        byArray2[123] = -27;
        byArray2[124] = 33;
        byArray2[125] = 57;
        byArray2[126] = -16;
        byArray2[127] = -96;
        sm2abgxgy = byArray2;
        random = SM2.getRandom();
    }

    private static SecureRandom getRandom() {
        SecureRandom random;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception exp) {
            random = new SecureRandom();
        }
        return random;
    }

    public static SM2 getInstance() {
        return SM2Holder.instance;
    }

    private static ECPoint kmg(ECPoint p, BigInteger k) {
        JPECPoint.Fp pp = new JPECPoint.Fp(gmec256, p.getX(), p.getY());
        return pp.multiply(k).toECPoint();
    }

    public void genKeyPair(byte[] privKey, byte[] pubKeyX, byte[] pubKeyY) {
        ECPoint kg;
        BigInteger k = null;
        int nBitLength = gmn.bitLength();
        do {
            k = new BigInteger(nBitLength, random);
            k = k.mod(gmn);
            kg = gmg.multiply(k);
            ECPoint kg2 = SM2.kmg(gmg, k);
            System.out.println("KG:\n" + kg.toString() + "\n" + kg2.toString());
        } while (kg.isInfinity());
        int i = 0;
        while (i < 32) {
            privKey[i] = 0;
            pubKeyX[i] = 0;
            pubKeyY[i] = 0;
            ++i;
        }
        byte[] temp = BigIntegers.asUnsignedByteArray(k);
        System.arraycopy(temp, 0, privKey, 32 - temp.length, temp.length);
        temp = BigIntegers.asUnsignedByteArray(kg.getX().toBigInteger());
        System.arraycopy(temp, 0, pubKeyX, 32 - temp.length, temp.length);
        temp = BigIntegers.asUnsignedByteArray(kg.getY().toBigInteger());
        System.arraycopy(temp, 0, pubKeyY, 32 - temp.length, temp.length);
    }

    public void genKeyPair(byte[] privkey, byte[] pubkey) {
        ECPoint kg;
        BigInteger k = null;
        int nBitLength = gmn.bitLength();
        do {
            k = new BigInteger(nBitLength, random);
        } while ((kg = SM2Constants.jg.multiply(k = k.mod(gmn)).toECPoint()).isInfinity());
        byte[] temp = BigIntegers.asUnsignedByteArray(k);
        int i = 0;
        while (i < 32) {
            privkey[i] = 0;
            ++i;
        }
        System.arraycopy(temp, 0, privkey, 32 - temp.length, temp.length);
        pubkey[0] = 4;
        i = 1;
        while (i < 65) {
            pubkey[i] = 0;
            ++i;
        }
        temp = BigIntegers.asUnsignedByteArray(kg.getX().toBigInteger());
        System.arraycopy(temp, 0, pubkey, 33 - temp.length, temp.length);
        temp = BigIntegers.asUnsignedByteArray(kg.getY().toBigInteger());
        System.arraycopy(temp, 0, pubkey, 65 - temp.length, temp.length);
    }

    public static byte[] signHash(byte[] msg_hash, byte[] privkey) {
        BigInteger k;
        BigInteger d;
        if (msg_hash.length != 32 || privkey.length != 32) {
            return null;
        }
        BigInteger e = new BigInteger(1, msg_hash);
        BigInteger r = null;
        BigInteger s = null;
        do {
            ECPoint p;
            BigInteger x;
            k = null;
            int nBitLength = gmn.bitLength();
            while ((k = new BigInteger(nBitLength, random)).equals(BigInteger.ZERO) || k.compareTo(gmn) >= 0 || (r = (x = (p = SM2.kmg(gmg, k)).getX().toBigInteger()).mod(gmn)).equals(BigInteger.ZERO) || e.add(r).compareTo(gmn) == 0) {
            }
            d = new BigInteger(1, privkey);
            r = e.add(r).mod(gmn);
        } while ((s = BigInteger.ONE.add(d).modInverse(gmn).multiply(k.add(d.multiply(r).negate())).mod(gmn)).equals(BigInteger.ZERO));
        byte[] x = new byte[32];
        byte[] y = new byte[32];
        x = BigIntegers.asUnsignedByteArray(r);
        y = BigIntegers.asUnsignedByteArray(s);
        return SM2.xy2sign(x, y);
    }

    public boolean verifyHash(byte[] msg_hash, byte[] r, byte[] s, byte[] x, byte[] y) {
        byte[] signature = new byte[64];
        System.arraycopy(r, 0, signature, 0, 32);
        System.arraycopy(s, 0, signature, 32, 32);
        byte[] pubkey = new byte[65];
        pubkey[0] = 4;
        System.arraycopy(x, 0, pubkey, 1, 32);
        System.arraycopy(y, 0, pubkey, 33, 32);
        return SM2.verifyHash(msg_hash, signature, pubkey);
    }

    private static ECPoint implShamirsTrick(JPECPoint P, BigInteger k, JPECPoint Q, BigInteger l) {
        int m = Math.max(k.bitLength(), l.bitLength());
        JPECPoint Z = P.add(Q);
        JPECPoint R = P.getInfinity();
        int i = m - 1;
        while (i >= 0) {
            R = R.twice();
            if (k.testBit(i)) {
                R = l.testBit(i) ? R.add(Z) : R.add(P);
            } else if (l.testBit(i)) {
                R = R.add(Q);
            }
            --i;
        }
        return R.toECPoint();
    }

    public static boolean verifyHash(byte[] msg_hash, byte[] signature, byte[] pubkey) {
        if (msg_hash.length != 32) {
            return false;
        }
        if (signature.length != 64 && signature.length != 65 && signature.length < 69) {
            return false;
        }
        if (pubkey.length != 64 && pubkey.length != 65) {
            return false;
        }
        BigInteger e = new BigInteger(1, msg_hash);
        BigInteger r = null;
        BigInteger s = null;
        if (signature.length >= 69) {
            byte[] x = new byte[32];
            byte[] y = new byte[32];
            SM2.sign2xy(signature, x, y);
            r = new BigInteger(1, x);
            s = new BigInteger(1, y);
        } else {
            byte[] signpart = new byte[32];
            int pos = 0;
            if (signature[0] == 4 && signature.length == 65) {
                pos = 1;
            }
            System.arraycopy(signature, pos, signpart, 0, 32);
            r = new BigInteger(1, signpart);
            System.arraycopy(signature, pos + 32, signpart, 0, 32);
            s = new BigInteger(1, signpart);
        }
        if (r.compareTo(BigInteger.ONE) < 0 || r.compareTo(gmn) >= 0) {
            return false;
        }
        if (s.compareTo(BigInteger.ONE) < 0 || s.compareTo(gmn) >= 0) {
            return false;
        }
        BigInteger t = r.add(s).mod(gmn);
        ECPoint Q = SM2.octect2point(pubkey);
        ECPoint xy1 = SM2.implShamirsTrick(SM2Constants.jg, s, new JPECPoint.Fp(Q), t);
        BigInteger v = xy1.getX().toBigInteger().add(e).mod(gmn);
        return v.compareTo(r) == 0;
    }

    public static ECPoint octect2point(byte[] pb) {
        byte[] x = new byte[32];
        byte[] y = new byte[32];
        switch (pb.length) {
            case 65: {
                int px = 1;
                int py = 33;
                if (pb[0] != 4) {
                    return null;
                }
                System.arraycopy(pb, px, x, 0, 32);
                System.arraycopy(pb, py, y, 0, 32);
                break;
            }
            case 64: {
                int px = 0;
                int py = 32;
                System.arraycopy(pb, px, x, 0, 32);
                System.arraycopy(pb, py, y, 0, 32);
                break;
            }
            default: {
                return null;
            }
        }
        return gmec256.createPoint(new BigInteger(1, x), new BigInteger(1, y), false);
    }

    public static ECPoint octect2point(byte[] pb, int offset, int length) {
        byte[] x = new byte[32];
        byte[] y = new byte[32];
        switch (length) {
            case 65: {
                int px = 1 + offset;
                int py = 33 + offset;
                if (pb[0] != 4) {
                    return null;
                }
                System.arraycopy(pb, px, x, 0, 32);
                System.arraycopy(pb, py, y, 0, 32);
                break;
            }
            case 64: {
                int px = 0 + offset;
                int py = 32 + offset;
                System.arraycopy(pb, px, x, 0, 32);
                System.arraycopy(pb, py, y, 0, 32);
                break;
            }
            default: {
                return null;
            }
        }
        return gmec256.createPoint(new BigInteger(1, x), new BigInteger(1, y), false);
    }

    public static void sign2xy(byte[] sign, byte[] x, byte[] y) {
        int x_delta = 0;
        int y_delta = 0;
        if (sign[3] == 33) {
            x_delta = 1;
        }
        if (sign[37 + x_delta] == 33) {
            y_delta = 1;
        }
        int i = 0;
        while (i < 32) {
            x[i] = sign[4 + x_delta + i];
            y[i] = sign[38 + x_delta + y_delta + i];
            ++i;
        }
    }

    public static byte[] xy2sign(byte[] x, byte[] y) {
        int x_delta = 0;
        int y_delta = 0;
        if (x.length == 32 && (x[0] & 0xFF) >= 128) {
            x_delta = 1;
        }
        if (y.length == 32 && (y[0] & 0xFF) >= 128) {
            y_delta = 1;
        }
        byte[] sign = new byte[70 + x_delta + y_delta];
        sign[0] = 48;
        sign[1] = (byte)(68 + x_delta + y_delta);
        sign[2] = 2;
        sign[3 + x_delta] = 0;
        sign[3] = (byte)(32 + x_delta);
        int pad_length = 32 - x.length;
        int i = 0;
        while (i < pad_length) {
            sign[4 + x_delta + i] = 0;
            ++i;
        }
        i = 0;
        while (i < x.length) {
            sign[4 + x_delta + i + pad_length] = x[i];
            ++i;
        }
        sign[36 + x_delta] = 2;
        sign[38 + x_delta] = 0;
        sign[37 + x_delta] = (byte)(32 + y_delta);
        pad_length = 32 - y.length;
        i = 0;
        while (i < pad_length) {
            sign[38 + x_delta + y_delta + i] = 0;
            ++i;
        }
        i = 0;
        while (i < y.length) {
            sign[38 + x_delta + y_delta + i + pad_length] = y[i];
            ++i;
        }
        return sign;
    }

    public static byte[] signData(byte[] id, byte[] data, byte[] privKey, byte[] pubkey) {
        SM3 sm3 = new SM3();
        if (id == null) {
            sm3.update(defaultIdAndLength);
        } else {
            int id_length = id.length;
            sm3.update((byte)(id_length >> 8));
            sm3.update((byte)(id_length & 0xFF));
            sm3.update(id);
        }
        sm3.update(sm2abgxgy);
        if (pubkey == null) {
            BigInteger d = new BigInteger(1, privKey);
            ECPoint pk = SM2Constants.jg.multiply(d).toECPoint();
            byte[] coordinate = new byte[32];
            byte[] temp = BigIntegers.asUnsignedByteArray(pk.getX().toBigInteger());
            System.arraycopy(temp, 0, coordinate, 32 - temp.length, temp.length);
            sm3.update(coordinate);
            temp = BigIntegers.asUnsignedByteArray(pk.getY().toBigInteger());
            System.arraycopy(temp, 0, coordinate, 32 - temp.length, temp.length);
            sm3.update(coordinate);
        } else {
            sm3.update(ByteBuffer.allocate(64).put(pubkey, 1, 64).array());
        }
        byte[] za = new byte[32];
        sm3.digest(za);
        sm3 = new SM3();
        sm3.update(za);
        sm3.update(data);
        byte[] msg_hash = new byte[32];
        sm3.digest(msg_hash);
        return SM2.signHash(msg_hash, privKey);
    }

    public static byte[] signData(byte[] data, byte[] privKey) {
        return SM2.signData(null, data, privKey, null);
    }

    public static byte[] signData(byte[] data, byte[] privKey, byte[] pubKey) {
        return SM2.signData(null, data, privKey, pubKey);
    }

    public static boolean verifyData(byte[] id, byte[] data, byte[] signature, byte[] pubkey) {
        if (data == null || signature == null || pubkey == null) {
            return false;
        }
        SM3 sm3 = new SM3();
        if (id == null) {
            sm3.update(defaultIdAndLength);
        } else {
            int id_length = id.length;
            sm3.update((byte)(id_length >> 8));
            sm3.update((byte)(id_length & 0xFF));
            sm3.update(id);
        }
        sm3.update(sm2abgxgy);
        sm3.update(ByteBuffer.allocate(64).put(pubkey, 1, 64).array());
        byte[] za = new byte[32];
        sm3.digest(za);
        sm3 = new SM3();
        sm3.update(za);
        sm3.update(data);
        byte[] msg_hash = new byte[32];
        sm3.digest(msg_hash);
        return SM2.verifyHash(msg_hash, signature, pubkey);
    }

    public static boolean verifyData(byte[] data, byte[] signature, byte[] pubkey) {
        return SM2.verifyData(null, data, signature, pubkey);
    }

    public static byte[] kdf(byte[] x2y2, int keySize) {
        if (keySize < 1) {
            return null;
        }
        SM3 md = new SM3();
        int mdLength = 32;
        int d = keySize / mdLength;
        int t = keySize % mdLength;
        byte[] result = new byte[keySize];
        byte[] last = new byte[mdLength];
        int ctr = 1;
        try {
            int i = 0;
            while (i < d) {
                byte[] ctrBytes = ByteBuffer.allocate(4).putInt(ctr).array();
                md.update(x2y2);
                md.update(ctrBytes);
                md.digest(result, i * mdLength);
                ++i;
                ++ctr;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("internal error");
        }
        if (t != 0) {
            byte[] ctrBytes = ByteBuffer.allocate(4).putInt(ctr).array();
            md.update(x2y2);
            md.update(ctrBytes);
            md.digest(last);
            System.arraycopy(last, 0, result, d * mdLength, t);
        }
        return result;
    }

    public static byte[] encrypt(byte[] msg, byte[] pubkey) {
        ECPoint pbk;
        ECPoint kg;
        BigInteger k = null;
        byte[] c = new byte[97 + msg.length];
        int nBitLength = gmn.bitLength();
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception exp) {
            random = new SecureRandom();
        }
        while (true) {
            k = new BigInteger(nBitLength, random);
            if ((k = k.mod(gmn)).compareTo(BigInteger.ZERO) <= 0) continue;
            kg = SM2Constants.jg.multiply(k).toECPoint();
            pbk = SM2.octect2point(pubkey);
            if (!(pbk = new JPECPoint.Fp(pbk).multiply(k).toECPoint()).isInfinity()) break;
        }
        byte[] tmpib = BigIntegers.asUnsignedByteArray(kg.getX().toBigInteger());
        c[0] = 4;
        System.arraycopy(tmpib, 0, c, 33 - tmpib.length, tmpib.length);
        tmpib = BigIntegers.asUnsignedByteArray(kg.getY().toBigInteger());
        System.arraycopy(tmpib, 0, c, 65 - tmpib.length, tmpib.length);
        byte[] xy2 = new byte[65];
        xy2[0] = 4;
        tmpib = BigIntegers.asUnsignedByteArray(pbk.getX().toBigInteger());
        System.arraycopy(tmpib, 0, xy2, 33 - tmpib.length, tmpib.length);
        tmpib = BigIntegers.asUnsignedByteArray(pbk.getY().toBigInteger());
        System.arraycopy(tmpib, 0, xy2, 65 - tmpib.length, tmpib.length);
        byte[] t = SM2.kdf(ByteBuffer.allocate(64).put(xy2, 1, 64).array(), msg.length);
        int i = 0;
        while (i < msg.length) {
            c[i + 97] = (byte)(msg[i] ^ t[i]);
            ++i;
        }
        SM3 md = new SM3();
        md.update(ByteBuffer.allocate(32).put(xy2, 1, 32).array());
        md.update(msg);
        md.update(ByteBuffer.allocate(32).put(xy2, 33, 32).array());
        md.digest(c, 65);
        return c;
    }

    public static boolean decrypt(byte[] ct, byte[] privkey, byte[] pt) {
        if (ct.length < 98 || privkey.length != 32) {
            return false;
        }
        int ctl = ct.length - 97;
        byte[] c2 = ByteBuffer.allocate(ctl).put(ct, 97, ctl).array();
        byte[] c3 = ByteBuffer.allocate(32).put(ct, 65, 32).array();
        ECPoint c1p = SM2.octect2point(ByteBuffer.allocate(65).put(ct, 0, 65).array());
        BigInteger d = new BigInteger(1, privkey);
        c1p = c1p.multiply(d);
        byte[] tmpib = BigIntegers.asUnsignedByteArray(c1p.getX().toBigInteger());
        byte[] xy = new byte[64];
        System.arraycopy(tmpib, 0, xy, 32 - tmpib.length, tmpib.length);
        tmpib = BigIntegers.asUnsignedByteArray(c1p.getY().toBigInteger());
        System.arraycopy(tmpib, 0, xy, 64 - tmpib.length, tmpib.length);
        byte[] t = SM2.kdf(xy, ctl);
        int i = 0;
        while (i < ctl) {
            pt[i] = (byte)(c2[i] ^ t[i]);
            ++i;
        }
        SM3 md = new SM3();
        md.update(ByteBuffer.allocate(32).put(xy, 0, 32).array());
        md.update(pt);
        md.update(ByteBuffer.allocate(32).put(xy, 32, 32).array());
        byte[] u = new byte[32];
        md.digest(u);
        int i2 = 0;
        while (i2 < 32) {
            if ((u[i2] & 0xFF) != (c3[i2] & 0xFF)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            Security.addProvider(new InfosecProvider());
            SM2 sm2i = SM2.getInstance();
            byte[] privKey = new byte[32];
            byte[] pubKey = new byte[65];
            byte[] msg_hash = new byte[32];
            String str = "This is string to sign";
            byte[] sign = new byte[72];
            boolean result = false;
            int max = 1;
            SM3 sm3 = null;
            sm2i.genKeyPair(privKey, pubKey);
            int i = 0;
            while (i < 32) {
                msg_hash[i] = (byte)(privKey[i] ^ pubKey[i + 1]);
                ++i;
            }
            long start = System.currentTimeMillis();
            i = 0;
            while (i < max) {
                sm3 = new SM3();
                sm3.update(str.getBytes());
                sm3.digest(msg_hash);
                sign = SM2.signHash(msg_hash, privKey);
                ++i;
            }
            long end = System.currentTimeMillis();
            System.out.println(String.valueOf(max) + " sm2sign operation(s) has elapsed " + (end - start) + " ms\n or " + (double)max * 1000.0 / (double)(end - start) + " ops");
            start = System.currentTimeMillis();
            i = 0;
            while (i < max) {
                sm3 = new SM3();
                sm3.update(str.getBytes());
                sm3.digest(msg_hash);
                result = SM2.verifyHash(msg_hash, sign, pubKey);
                ++i;
            }
            end = System.currentTimeMillis();
            System.out.println(String.valueOf(max) + " sm2verify operation(s) has elapsed " + (end - start) + " ms\n or " + (double)max * 1000.0 / (double)(end - start) + " ops");
            if (!result) {
                System.out.println("SM2 Verification failed!");
            } else {
                System.out.println("SM2 verification is OK!");
            }
            byte[] hash3 = new byte[]{-5, 57, -93, -5, 77, -34, 90, -12, 3, 68, -71, -31, 126, -113, -56, 48, -123, 114, 14, -62, -57, 97, 87, 121, 81, 83, 34, -95, -72, -72, 30, 4};
            byte[] byArray = new byte[71];
            byArray[0] = 48;
            byArray[1] = 69;
            byArray[2] = 2;
            byArray[3] = 32;
            byArray[4] = 125;
            byArray[5] = -50;
            byArray[6] = 77;
            byArray[7] = 45;
            byArray[8] = 116;
            byArray[9] = -89;
            byArray[10] = 49;
            byArray[11] = 27;
            byArray[12] = -119;
            byArray[13] = -111;
            byArray[14] = -15;
            byArray[15] = 11;
            byArray[16] = 19;
            byArray[17] = -46;
            byArray[18] = -69;
            byArray[19] = 30;
            byArray[20] = -19;
            byArray[21] = -5;
            byArray[22] = 23;
            byArray[23] = -40;
            byArray[24] = 64;
            byArray[25] = -80;
            byArray[26] = 47;
            byArray[27] = -95;
            byArray[28] = 120;
            byArray[29] = 83;
            byArray[30] = -48;
            byArray[31] = -108;
            byArray[32] = -116;
            byArray[33] = -15;
            byArray[34] = 35;
            byArray[35] = 49;
            byArray[36] = 2;
            byArray[37] = 33;
            byArray[39] = -73;
            byArray[40] = 84;
            byArray[41] = -116;
            byArray[42] = -31;
            byArray[43] = -78;
            byArray[44] = 67;
            byArray[45] = 89;
            byArray[46] = 2;
            byArray[47] = 31;
            byArray[48] = 4;
            byArray[49] = 28;
            byArray[50] = 121;
            byArray[51] = 35;
            byArray[52] = 25;
            byArray[53] = 33;
            byArray[54] = -75;
            byArray[55] = -11;
            byArray[56] = 9;
            byArray[57] = -57;
            byArray[58] = 91;
            byArray[59] = -44;
            byArray[60] = -95;
            byArray[61] = -108;
            byArray[62] = -112;
            byArray[63] = -101;
            byArray[64] = 92;
            byArray[65] = 40;
            byArray[66] = -89;
            byArray[67] = -108;
            byArray[68] = 43;
            byArray[69] = -10;
            byArray[70] = 35;
            byte[] signature3 = byArray;
            byte[] pk3 = new byte[]{4, -23, -55, -53, 126, -119, -59, 55, -43, -56, 56, 78, 70, 25, -107, -34, -116, 34, 109, 42, 3, 100, 74, 91, -53, -65, 69, -98, -57, 9, -17, 27, -66, -98, -70, 83, 45, -73, -36, 66, -127, -74, -79, -6, 106, -29, -31, 112, -107, -75, 82, -102, -51, -69, 20, 80, 24, 99, -30, 15, 27, 124, -118, -109, -110};
            result = SM2.verifyHash(hash3, signature3, pk3);
            if (!result) {
                System.out.println("SM2 Vector Verification failed!");
            } else {
                System.out.println("SM2 Vector verification is OK!");
            }
            String msg = "Beijing Infosec Technologies Co.,Ltd. is a Chinese company based in \u5317\u4eac.";
            String id = "pony wang";
            byte[] signature4 = SM2.signData(id.getBytes(), msg.getBytes(), privKey, null);
            result = SM2.verifyData(id.getBytes(), msg.getBytes(), signature4, pubKey);
            if (!result) {
                System.out.println("SM2 with ID Verification failed!");
            } else {
                System.out.println("SM2 with ID verification is OK!");
            }
            byte[] ct = SM2.encrypt(msg.getBytes(), pubKey);
            byte[] pt = new byte[ct.length - 97];
            result = SM2.decrypt(ct, privKey, pt);
            if (!result) {
                System.out.println("SM2 encryption/decryption failed!");
            } else {
                System.out.println("SM2 encryption/decryption is OK!\n" + new String(pt));
            }
            System.out.println("End!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class SM2Holder {
        static SM2 instance = new SM2();

        SM2Holder() {
        }
    }
}

