/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce;

import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1Set;
import cn.com.infosec.asn1.DERConstructedSequence;
import cn.com.infosec.asn1.DERConstructedSet;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERInputStream;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.pkcs.ContentInfo;
import cn.com.infosec.asn1.pkcs.IssuerAndSerialNumber;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.pkcs.SignedData;
import cn.com.infosec.asn1.pkcs.SignerInfo;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.CertificateList;
import cn.com.infosec.asn1.x509.DigestInfo;
import cn.com.infosec.asn1.x509.X509CertificateStructure;
import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.asn1.x509.X509ObjectIdentifiers;
import cn.com.infosec.crypto.AsymmetricBlockCipher;
import cn.com.infosec.crypto.Digest;
import cn.com.infosec.crypto.digests.SHA1Digest;
import cn.com.infosec.crypto.encodings.PKCS1Encoding;
import cn.com.infosec.crypto.engines.RSAEngine;
import cn.com.infosec.crypto.params.RSAKeyParameters;
import cn.com.infosec.jce.X509Principal;
import cn.com.infosec.jce.provider.RSAUtil;
import cn.com.infosec.jce.provider.X509CRLObject;
import cn.com.infosec.jce.provider.X509CertificateObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PKCS7SignedDataICBC
implements PKCSObjectIdentifiers {
    private int version;
    private int signerversion;
    private Set digestalgos;
    private Collection certs;
    private Collection crls;
    private X509Certificate signCert;
    private byte[] digest;
    private String digestAlgorithm;
    private String digestEncryptionAlgorithm;
    private SignatureICBC sig;
    private transient PrivateKey privKey;
    private byte[] contentData;
    private final String ID_PKCS7_DATA = "1.2.840.113549.1.7.1";
    private final String ID_PKCS7_SIGNED_DATA = "1.2.840.113549.1.7.2";
    private final String ID_MD5 = "1.2.840.113549.2.5";
    private final String ID_MD2 = "1.2.840.113549.2.2";
    private final String ID_SHA1 = "1.3.14.3.2.26";
    private final String ID_RSA = "1.2.840.113549.1.1.1";
    private final String ID_DSA = "1.2.840.10040.4.1";

    public PKCS7SignedDataICBC(byte[] in, byte[] hash) throws SecurityException, CRLException, InvalidKeyException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException {
        this(in, hash, "INFOSEC");
    }

    public PKCS7SignedDataICBC(byte[] in, byte[] hash, String provider) throws SecurityException, CRLException, InvalidKeyException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException {
        Enumeration ec;
        DERObject pkcs;
        DERInputStream din = new DERInputStream(new ByteArrayInputStream(in));
        try {
            pkcs = din.readObject();
        }
        catch (IOException e) {
            throw new SecurityException("can't decode PKCS7SignedData object");
        }
        if (!(pkcs instanceof DERConstructedSequence)) {
            throw new SecurityException("Not a valid PKCS#7 object - not a sequence");
        }
        ContentInfo content = ContentInfo.getInstance(pkcs);
        if (!content.getContentType().equals(signedData)) {
            throw new SecurityException("Not a valid PKCS#7 signed-data object - wrong header " + content.getContentType().getId());
        }
        SignedData data = SignedData.getInstance(content.getContent());
        this.certs = new ArrayList();
        if (data.getCertificates() != null) {
            ec = ASN1Set.getInstance(data.getCertificates()).getObjects();
            while (ec.hasMoreElements()) {
                this.certs.add(new X509CertificateObject(X509CertificateStructure.getInstance(ec.nextElement())));
            }
        }
        this.crls = new ArrayList();
        if (data.getCRLs() != null) {
            ec = ASN1Set.getInstance(data.getCRLs()).getObjects();
            while (ec.hasMoreElements()) {
                this.crls.add(new X509CRLObject(CertificateList.getInstance(ec.nextElement())));
            }
        }
        this.version = data.getVersion().getValue().intValue();
        ContentInfo dataContentInfo = data.getContentInfo();
        DEREncodable derEnc = dataContentInfo.getContent();
        if (derEnc != null) {
            ASN1OctetString asn1octet = (ASN1OctetString)derEnc;
            this.contentData = asn1octet.getOctets();
        } else {
            this.contentData = null;
        }
        this.digestalgos = new HashSet();
        Enumeration e = data.getDigestAlgorithms().getObjects();
        while (e.hasMoreElements()) {
            DERConstructedSequence s = (DERConstructedSequence)e.nextElement();
            DERObjectIdentifier o = (DERObjectIdentifier)s.getObjectAt(0);
            this.digestalgos.add(o.getId());
        }
        DERConstructedSet signerinfos = (DERConstructedSet)data.getSignerInfos();
        if (signerinfos.getSize() != 1) {
            throw new SecurityException("This PKCS#7 object has multiple SignerInfos - only one is supported at this time");
        }
        SignerInfo signerInfo = SignerInfo.getInstance(signerinfos.getObjectAt(0));
        this.signerversion = signerInfo.getVersion().getValue().intValue();
        IssuerAndSerialNumber isAnds = signerInfo.getIssuerAndSerialNumber();
        BigInteger serialNumber = isAnds.getCertificateSerialNumber().getValue();
        X509Principal issuer = new X509Principal(isAnds.getName());
        for (X509Certificate cert : this.certs) {
            if (!serialNumber.equals(cert.getSerialNumber()) || !issuer.equals(cert.getIssuerDN())) continue;
            this.signCert = cert;
            break;
        }
        if (this.signCert == null) {
            throw new SecurityException("Can't find signing certificate with serial " + serialNumber.toString(16));
        }
        this.digestAlgorithm = signerInfo.getDigestAlgorithm().getObjectId().getId();
        this.digest = signerInfo.getEncryptedDigest().getOctets();
        this.digestEncryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm().getObjectId().getId();
        this.sig = new SignatureICBC();
        this.sig.engineInitVerify(this.signCert.getPublicKey());
    }

    public PKCS7SignedDataICBC(PrivateKey privKey, Certificate[] certChain, String hashAlgorithm) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this(privKey, certChain, hashAlgorithm, "INFOSEC");
    }

    public PKCS7SignedDataICBC(PrivateKey privKey, Certificate[] certChain, String hashAlgorithm, String provider) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this(privKey, certChain, null, hashAlgorithm, provider);
    }

    public PKCS7SignedDataICBC(PrivateKey privKey, Certificate[] certChain, CRL[] crlList, String hashAlgorithm, String provider) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this.privKey = privKey;
        if (hashAlgorithm.equals("MD5")) {
            this.digestAlgorithm = "1.2.840.113549.2.5";
        } else if (hashAlgorithm.equals("MD2")) {
            this.digestAlgorithm = "1.2.840.113549.2.2";
        } else if (hashAlgorithm.equals("SHA")) {
            this.digestAlgorithm = "1.3.14.3.2.26";
        } else if (hashAlgorithm.equals("SHA1")) {
            this.digestAlgorithm = "1.3.14.3.2.26";
        } else {
            throw new NoSuchAlgorithmException("Unknown Hash Algorithm " + hashAlgorithm);
        }
        this.signerversion = 1;
        this.version = 1;
        this.certs = new ArrayList();
        this.crls = new ArrayList();
        this.digestalgos = new HashSet();
        this.digestalgos.add(this.digestAlgorithm);
        this.signCert = (X509Certificate)certChain[0];
        int i = 0;
        while (i < certChain.length) {
            this.certs.add(certChain[i]);
            ++i;
        }
        if (crlList != null) {
            i = 0;
            while (i < crlList.length) {
                this.crls.add(crlList[i]);
                ++i;
            }
        }
        this.digestEncryptionAlgorithm = privKey.getAlgorithm();
        if (this.digestEncryptionAlgorithm.equals("RSA")) {
            this.digestEncryptionAlgorithm = "1.2.840.113549.1.1.1";
        } else if (this.digestEncryptionAlgorithm.equals("DSA")) {
            this.digestEncryptionAlgorithm = "1.2.840.10040.4.1";
        } else {
            throw new NoSuchAlgorithmException("Unknown Key Algorithm " + this.digestEncryptionAlgorithm);
        }
        this.sig = new SignatureICBC();
        this.sig.initSign(privKey);
    }

    public String getDigestAlgorithm() {
        String da = this.digestAlgorithm;
        String dea = this.digestEncryptionAlgorithm;
        if (this.digestAlgorithm.equals("1.2.840.113549.2.5")) {
            da = "MD5";
        } else if (this.digestAlgorithm.equals("1.2.840.113549.2.2")) {
            da = "MD2";
        } else if (this.digestAlgorithm.equals("1.3.14.3.2.26")) {
            da = "SHA1";
        }
        if (this.digestEncryptionAlgorithm.equals("1.2.840.113549.1.1.1")) {
            dea = "RSA";
        } else if (this.digestEncryptionAlgorithm.equals("1.2.840.10040.4.1")) {
            dea = "DSA";
        }
        return String.valueOf(da) + "with" + dea;
    }

    public void reset() {
        try {
            if (this.privKey == null) {
                this.sig.initVerify(this.signCert.getPublicKey());
            } else {
                this.sig.initSign(this.privKey);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public Certificate[] getCertificates() {
        return this.certs.toArray(new X509Certificate[0]);
    }

    public Collection getCRLs() {
        return this.crls;
    }

    public X509Certificate getSigningCertificate() {
        return this.signCert;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSigningInfoVersion() {
        return this.signerversion;
    }

    public byte[] getContentData() {
        return this.contentData;
    }

    public void update(byte buf) throws SignatureException {
        this.sig.update(buf);
    }

    public void update(byte[] buf, int off, int len) throws SignatureException {
        this.sig.update(buf, off, len);
    }

    public boolean verify() throws SignatureException {
        return this.sig.verify(this.digest);
    }

    public boolean verify(byte[] hash) throws SignatureException {
        return this.sig.engineVerify(hash, this.digest);
    }

    private DERObject getIssuer(byte[] enc) {
        try {
            DERInputStream in = new DERInputStream(new ByteArrayInputStream(enc));
            DERConstructedSequence seq = (DERConstructedSequence)in.readObject();
            return (DERObject)seq.getObjectAt(seq.getObjectAt(0) instanceof DERTaggedObject ? 3 : 2);
        }
        catch (IOException e) {
            throw new Error("IOException reading from ByteArray: " + e);
        }
    }

    public byte[] getEncoded() {
        return this.getEncoded(null);
    }

    public byte[] getEncoded(byte[] _contentData) {
        try {
            if (this.digest == null) {
                this.digest = this.sig.sign();
            }
            DERConstructedSet algos = new DERConstructedSet();
            Iterator i = this.digestalgos.iterator();
            while (i.hasNext()) {
                AlgorithmIdentifier a = new AlgorithmIdentifier(new DERObjectIdentifier((String)i.next()), null);
                algos.addObject(a);
            }
            DERConstructedSequence contentinfo = new DERConstructedSequence();
            contentinfo.addObject(new DERObjectIdentifier("1.2.840.113549.1.7.1"));
            if (_contentData != null) {
                DEROctetString octets = new DEROctetString(_contentData);
                DERTaggedObject tagged = new DERTaggedObject(0, octets);
                contentinfo.addObject(tagged);
            }
            DERConstructedSet dercertificates = new DERConstructedSet();
            Iterator i2 = this.certs.iterator();
            while (i2.hasNext()) {
                DERInputStream tempstream = new DERInputStream(new ByteArrayInputStream(((X509Certificate)i2.next()).getEncoded()));
                dercertificates.addObject(tempstream.readObject());
            }
            DERConstructedSequence signerinfo = new DERConstructedSequence();
            signerinfo.addObject(new DERInteger(this.signerversion));
            IssuerAndSerialNumber isAnds = new IssuerAndSerialNumber(new X509Name((DERConstructedSequence)this.getIssuer(this.signCert.getTBSCertificate())), new DERInteger(this.signCert.getSerialNumber()));
            signerinfo.addObject(isAnds);
            signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestAlgorithm), null));
            signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestEncryptionAlgorithm), null));
            signerinfo.addObject(new DEROctetString(this.digest));
            DERConstructedSequence body = new DERConstructedSequence();
            body.addObject(new DERInteger(this.version));
            body.addObject(algos);
            body.addObject(contentinfo);
            body.addObject(new DERTaggedObject(false, 0, dercertificates));
            if (this.crls.size() > 0) {
                DERConstructedSet dercrls = new DERConstructedSet();
                Iterator i3 = this.crls.iterator();
                while (i3.hasNext()) {
                    DERInputStream t = new DERInputStream(new ByteArrayInputStream(((X509CRL)i3.next()).getEncoded()));
                    dercrls.addObject(t.readObject());
                }
                body.addObject(new DERTaggedObject(false, 1, dercrls));
            }
            DERConstructedSet signerinfos = new DERConstructedSet();
            signerinfos.addObject(signerinfo);
            body.addObject(signerinfos);
            DERConstructedSequence whole = new DERConstructedSequence();
            whole.addObject(new DERObjectIdentifier("1.2.840.113549.1.7.2"));
            whole.addObject(new DERTaggedObject(0, body));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dout = new DEROutputStream(bOut);
            dout.writeObject(whole);
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    class SignatureICBC
    extends Signature
    implements PKCSObjectIdentifiers,
    X509ObjectIdentifiers {
        private Digest digest;
        private AsymmetricBlockCipher cipher;
        private AlgorithmIdentifier algId;
        private byte[] hash;

        public SignatureICBC() {
            super("SHA1withRSA");
            this.digest = new SHA1Digest();
            this.cipher = new PKCS1Encoding(new RSAEngine());
            this.algId = new AlgorithmIdentifier(id_SHA1, null);
        }

        protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
            if (!(publicKey instanceof RSAPublicKey)) {
                throw new InvalidKeyException("Supplied key is not a RSAPublicKey instance");
            }
            RSAKeyParameters param = RSAUtil.generatePublicKeyParameter((RSAPublicKey)publicKey);
            this.digest.reset();
            this.cipher.init(false, param);
        }

        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            if (!(privateKey instanceof RSAPrivateKey)) {
                throw new InvalidKeyException("Supplied key is not a RSAPrivateKey instance");
            }
            RSAKeyParameters param = RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey);
            this.digest.reset();
            this.cipher.init(true, param);
        }

        protected void engineUpdate(byte b) throws SignatureException {
            this.digest.update(b);
        }

        protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
            this.digest.update(b, off, len);
        }

        protected byte[] engineSign() throws SignatureException {
            byte[] hash = new byte[this.digest.getDigestSize()];
            this.digest.doFinal(hash, 0);
            try {
                byte[] bytes = this.derEncode(hash);
                return this.cipher.processBlock(bytes, 0, bytes.length);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new SignatureException("key too small for signature type");
            }
            catch (Exception e) {
                throw new SignatureException(e.toString());
            }
        }

        protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
            DigestInfo digInfo;
            byte[] hash = new byte[this.digest.getDigestSize()];
            this.digest.doFinal(hash, 0);
            try {
                byte[] sig = this.cipher.processBlock(sigBytes, 0, sigBytes.length);
                digInfo = this.derDecode(sig);
            }
            catch (Exception e) {
                return false;
            }
            if (!digInfo.getAlgorithmId().equals(this.algId)) {
                return false;
            }
            byte[] sigHash = digInfo.getDigest();
            if (hash.length != sigHash.length) {
                return false;
            }
            int i = 0;
            while (i < hash.length) {
                if (sigHash[i] != hash[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        protected boolean engineVerify(byte[] hash, byte[] sigBytes) throws SignatureException {
            DigestInfo digInfo;
            try {
                byte[] sig = this.cipher.processBlock(sigBytes, 0, sigBytes.length);
                digInfo = this.derDecode(sig);
            }
            catch (Exception e) {
                return false;
            }
            if (!digInfo.getAlgorithmId().equals(this.algId)) {
                return false;
            }
            byte[] sigHash = digInfo.getDigest();
            if (hash.length != sigHash.length) {
                return false;
            }
            int i = 0;
            while (i < hash.length) {
                if (sigHash[i] != hash[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        protected void engineSetParameter(AlgorithmParameterSpec params) {
            throw new UnsupportedOperationException("engineSetParameter unsupported");
        }

        protected void engineSetParameter(String param, Object value) {
            throw new UnsupportedOperationException("engineSetParameter unsupported");
        }

        protected Object engineGetParameter(String param) {
            throw new UnsupportedOperationException("engineSetParameter unsupported");
        }

        private byte[] derEncode(byte[] hash) throws IOException {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            DigestInfo dInfo = new DigestInfo(this.algId, hash);
            dOut.writeObject(dInfo);
            return bOut.toByteArray();
        }

        private DigestInfo derDecode(byte[] encoding) throws IOException {
            ByteArrayInputStream bIn = new ByteArrayInputStream(encoding);
            DERInputStream dIn = new DERInputStream(bIn);
            return new DigestInfo((ASN1Sequence)dIn.readObject());
        }
    }
}

