/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce;

import cn.com.infosec.asn1.DERConstructedSequence;
import cn.com.infosec.asn1.DERInputStream;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.jce.PKCS7SignedData;
import cn.com.infosec.jce.provider.X509CRLObjectFX;
import cn.com.infosec.jce.provider.X509CertificateObjectFX;
import cn.com.infosec.jce.provider.fastparser.DerUtil;
import cn.com.infosec.jce.provider.fastparser.FastPkcs7;
import cn.com.infosec.jce.provider.fastparser.Item;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;

public class PKCS7SignedDataFX
extends PKCS7SignedData {
    byte[] bsPKCS7 = null;
    FastPkcs7 fxPKCS7 = new FastPkcs7();
    String provider = "";
    boolean isInvokedOldConstructMethod = false;

    public PKCS7SignedDataFX(byte[] in) throws SecurityException, CRLException, InvalidKeyException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException {
        this(in, "INFOSEC");
    }

    private void invokedOldConstructMethod() throws SecurityException, CRLException, InvalidKeyException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException {
        if (this.isInvokedOldConstructMethod) {
            return;
        }
        this.PKCS7SignedData2(this.bsPKCS7, this.provider);
        this.isInvokedOldConstructMethod = true;
    }

    public PKCS7SignedDataFX(byte[] in, String provider) throws SecurityException, CRLException, InvalidKeyException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException {
        this.fxPKCS7.pkcs7SignedData(in);
        this.provider = provider;
        this.bsPKCS7 = in;
    }

    String getDigestAlgorithmExt() {
        return "";
    }

    String getDigestEncryptionAlgorithmExt() {
        return "";
    }

    public String getDigestAlgorithm() {
        String da = this.fxPKCS7.getDigestAlgorithm();
        String dea = this.fxPKCS7.getDigestEncryptionAlgorithm();
        if (da.equals("1.2.840.113549.2.5")) {
            da = "MD5";
        } else if (da.equals("1.2.840.113549.2.2")) {
            da = "MD2";
        } else if (da.equals("1.3.14.3.2.26")) {
            da = "SHA1";
        }
        if (dea.equals("1.2.840.113549.1.1.1")) {
            dea = "RSA";
        } else if (dea.equals("1.2.840.10040.4.1")) {
            dea = "DSA";
        }
        return String.valueOf(da) + "with" + dea;
    }

    public void reset() {
        try {
            this.invokedOldConstructMethod();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        try {
            if (this.privKey == null) {
                this.sig.initVerify(this.signCert.getPublicKey());
            } else {
                this.sig.initSign(this.privKey);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public Certificate[] getCertificates() {
        if (this.certs == null || this.certs.size() == 0) {
            ArrayList alCerts = this.fxPKCS7.getCerts();
            this.certs = new ArrayList();
            int i = 0;
            while (i < alCerts.size()) {
                Item itCert = (Item)alCerts.get(i);
                byte[] bsCert = new byte[itCert.length + itCert.tagsize];
                System.arraycopy(this.bsPKCS7, itCert.offset - itCert.tagsize, bsCert, 0, bsCert.length);
                this.certs.add(new X509CertificateObjectFX(bsCert));
                ++i;
            }
        }
        return this.certs.toArray(new X509Certificate[0]);
    }

    public Collection getCRLs() {
        if (this.crls == null || this.crls.size() == 0) {
            ArrayList alCrls = this.fxPKCS7.getCrls();
            this.crls = new ArrayList();
            int i = 0;
            while (i < alCrls.size()) {
                Item itCrl = (Item)alCrls.get(i);
                byte[] bsCrl = new byte[itCrl.length + itCrl.tagsize];
                System.arraycopy(this.bsPKCS7, itCrl.offset - itCrl.tagsize, bsCrl, 0, bsCrl.length);
                try {
                    this.crls.add(new X509CRLObjectFX(bsCrl));
                }
                catch (CRLException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        return this.crls;
    }

    public X509Certificate getSigningCertificate() {
        if (this.signCert == null) {
            Item signCertItem = this.fxPKCS7.getSignCert();
            byte[] bsData = null;
            bsData = DerUtil.getItemDataAndTag(this.bsPKCS7, signCertItem);
            this.signCert = new X509CertificateObjectFX(bsData);
        }
        return this.signCert;
    }

    public int getVersion() {
        this.version = this.fxPKCS7.getVersion();
        return this.version;
    }

    public int getSigningInfoVersion() {
        this.signerversion = this.fxPKCS7.getSignInfoVersion();
        return this.signerversion;
    }

    public byte[] getContentData() {
        if (this.contentData == null) {
            Item rawDataItem = this.fxPKCS7.getRawData();
            this.contentData = DerUtil.getItemData(this.bsPKCS7, rawDataItem);
        }
        return this.contentData;
    }

    public boolean verify() throws SignatureException {
        if (this.digest == null) {
            Item digestItem = this.fxPKCS7.getDigest();
            this.digest = DerUtil.getItemData(this.bsPKCS7, digestItem);
        }
        try {
            this.sig = Signature.getInstance(this.getDigestAlgorithm(), this.provider);
            this.signCert = this.getSigningCertificate();
            this.sig.initVerify(this.signCert.getPublicKey());
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        return this.sig.verify(this.digest);
    }

    private DERObject getIssuer(byte[] enc) {
        try {
            DERInputStream in = new DERInputStream(new ByteArrayInputStream(enc));
            DERConstructedSequence seq = (DERConstructedSequence)in.readObject();
            return (DERObject)seq.getObjectAt(seq.getObjectAt(0) instanceof DERTaggedObject ? 3 : 2);
        }
        catch (IOException e) {
            throw new Error("IOException reading from ByteArray: " + e);
        }
    }

    public byte[] getEncoded() {
        return this.bsPKCS7;
    }
}

