/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.util;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1Object;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.nist.NISTNamedCurves;
import cn.com.infosec.asn1.oiw.ElGamalParameter;
import cn.com.infosec.asn1.oiw.OIWObjectIdentifiers;
import cn.com.infosec.asn1.pkcs.DHParameter;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.pkcs.PrivateKeyInfo;
import cn.com.infosec.asn1.pkcs.RSAPrivateKeyStructure;
import cn.com.infosec.asn1.sec.ECPrivateKeyStructure;
import cn.com.infosec.asn1.sec.SECNamedCurves;
import cn.com.infosec.asn1.teletrust.TeleTrusTNamedCurves;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.DSAParameter;
import cn.com.infosec.asn1.x9.X962NamedCurves;
import cn.com.infosec.asn1.x9.X962Parameters;
import cn.com.infosec.asn1.x9.X9ECParameters;
import cn.com.infosec.asn1.x9.X9ObjectIdentifiers;
import cn.com.infosec.crypto.params.AsymmetricKeyParameter;
import cn.com.infosec.crypto.params.DHParameters;
import cn.com.infosec.crypto.params.DHPrivateKeyParameters;
import cn.com.infosec.crypto.params.DSAParameters;
import cn.com.infosec.crypto.params.DSAPrivateKeyParameters;
import cn.com.infosec.crypto.params.ECDomainParameters;
import cn.com.infosec.crypto.params.ECPrivateKeyParameters;
import cn.com.infosec.crypto.params.ElGamalParameters;
import cn.com.infosec.crypto.params.ElGamalPrivateKeyParameters;
import cn.com.infosec.crypto.params.RSAPrivateCrtKeyParameters;
import java.io.IOException;
import java.io.InputStream;

public class PrivateKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] privateKeyInfoData) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(ASN1Object.fromByteArray(privateKeyInfoData)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inStr) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(new ASN1InputStream(inStr).readObject()));
    }

    public static AsymmetricKeyParameter createKey(PrivateKeyInfo keyInfo) throws IOException {
        AlgorithmIdentifier algId = keyInfo.getAlgorithmId();
        if (algId.getObjectId().equals(PKCSObjectIdentifiers.rsaEncryption)) {
            RSAPrivateKeyStructure keyStructure = new RSAPrivateKeyStructure((ASN1Sequence)keyInfo.getPrivateKey());
            return new RSAPrivateCrtKeyParameters(keyStructure.getModulus(), keyStructure.getPublicExponent(), keyStructure.getPrivateExponent(), keyStructure.getPrime1(), keyStructure.getPrime2(), keyStructure.getExponent1(), keyStructure.getExponent2(), keyStructure.getCoefficient());
        }
        if (algId.getObjectId().equals(PKCSObjectIdentifiers.dhKeyAgreement)) {
            DHParameter params = new DHParameter((ASN1Sequence)keyInfo.getAlgorithmId().getParameters());
            DERInteger derX = (DERInteger)keyInfo.getPrivateKey();
            return new DHPrivateKeyParameters(derX.getValue(), new DHParameters(params.getP(), params.getG()));
        }
        if (algId.getObjectId().equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            ElGamalParameter params = new ElGamalParameter((ASN1Sequence)keyInfo.getAlgorithmId().getParameters());
            DERInteger derX = (DERInteger)keyInfo.getPrivateKey();
            return new ElGamalPrivateKeyParameters(derX.getValue(), new ElGamalParameters(params.getP(), params.getG()));
        }
        if (algId.getObjectId().equals(X9ObjectIdentifiers.id_dsa)) {
            DSAParameter params = new DSAParameter((ASN1Sequence)keyInfo.getAlgorithmId().getParameters());
            DERInteger derX = (DERInteger)keyInfo.getPrivateKey();
            return new DSAPrivateKeyParameters(derX.getValue(), new DSAParameters(params.getP(), params.getQ(), params.getG()));
        }
        if (algId.getObjectId().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            X962Parameters params = new X962Parameters((DERObject)keyInfo.getAlgorithmId().getParameters());
            ECDomainParameters dParams = null;
            if (params.isNamedCurve()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)params.getParameters();
                X9ECParameters ecP = X962NamedCurves.getByOID(oid);
                if (ecP == null && (ecP = SECNamedCurves.getByOID(oid)) == null && (ecP = NISTNamedCurves.getByOID(oid)) == null) {
                    ecP = TeleTrusTNamedCurves.getByOID(oid);
                }
                dParams = new ECDomainParameters(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
            } else {
                X9ECParameters ecP = new X9ECParameters((ASN1Sequence)params.getParameters());
                dParams = new ECDomainParameters(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
            }
            ECPrivateKeyStructure ec = new ECPrivateKeyStructure((ASN1Sequence)keyInfo.getPrivateKey());
            return new ECPrivateKeyParameters(ec.getKey(), dParams);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }
}

