/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.tls;

import cn.com.infosec.crypto.Digest;
import cn.com.infosec.crypto.macs.HMac;
import cn.com.infosec.crypto.params.KeyParameter;
import cn.com.infosec.crypto.tls.TlsUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class TlsMac {
    private long seqNo;
    private HMac mac;

    protected TlsMac(Digest digest, byte[] key_block, int offset, int len) {
        this.mac = new HMac(digest);
        KeyParameter param = new KeyParameter(key_block, offset, len);
        this.mac.init(param);
        this.seqNo = 0L;
    }

    protected int getSize() {
        return this.mac.getMacSize();
    }

    protected byte[] calculateMac(short type, byte[] message, int offset, int len) {
        try {
            ByteArrayOutputStream bosMac = new ByteArrayOutputStream();
            TlsUtils.writeUint64(this.seqNo++, bosMac);
            TlsUtils.writeUint8(type, bosMac);
            TlsUtils.writeVersion(bosMac);
            TlsUtils.writeUint16(len, bosMac);
            bosMac.write(message, offset, len);
            byte[] macData = bosMac.toByteArray();
            this.mac.update(macData, 0, macData.length);
            byte[] result = new byte[this.mac.getMacSize()];
            this.mac.doFinal(result, 0);
            this.mac.reset();
            return result;
        }
        catch (IOException e) {
            throw new IllegalStateException("Internal error during mac calculation");
        }
    }
}

